package cn.ps1.soar.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.OrgnService;

import javax.servlet.http.HttpServletRequest;

/**
 * 公司内部组织架构维护管理
 * <p>
 * 组织（Orgn）|部门（Division）|员工（Employee）|职责（Job）|职级（Rank）
 * 
 * @author Fulin
 * @version 1.0 $Date: 2023.12.30
 * @since openjdk-1.8
 */
@Scope("singleton")
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class OrgnController {

	@Autowired
	private OrgnService orgnSvc;

	/** 组织 */

	/**
	 * 同一个组织架构下，根据部门（orgnDept）查询所有用户、岗位数据一览
	 */
	@RequestMapping(value = "/getEmpOfDept", method = RequestMethod.POST)
	public Object getEmpOfDept(HttpServletRequest req) {
		return orgnSvc.getEmpOfDept(req);
	}

	/**
	 * 同一个组织架构下，查询用户及所在部门数据一览
	 */
	@RequestMapping(value = "/getEmpInDept", method = RequestMethod.POST)
	public Object getEmpInDept(HttpServletRequest req) {
		return orgnSvc.getEmpInDept(req);
	}

	/**
	 * 同一个组织架构下，根据岗位（orgnJob）查询用户及所在部门数据
	 */
	@RequestMapping(value = "/getEmpByJob", method = RequestMethod.POST)
	public Object getEmpByJob(HttpServletRequest req) {
		return orgnSvc.getEmpByJob(req);
	}

	/**
	 * 增加一条员工的组织数据
	 */
	@RequestMapping(value = "/addOrgn", method = RequestMethod.POST)
	public Object addOrgn(HttpServletRequest req) {
		return orgnSvc.addOrgn(req);
	}

	/**
	 * 删除一条员工的组织数据
	 */
	@RequestMapping(value = "/delOrgn", method = RequestMethod.POST)
	public Object delOrgn(HttpServletRequest req) {
		return orgnSvc.delOrgn(req);
	}

	/** 部门 */

	/**
	 * 查询部门数据一览
	 */
	@RequestMapping(value = "/getDivnList", method = RequestMethod.POST)
	public Object getDeptList(HttpServletRequest req) {
		return orgnSvc.getDeptList(req);
	}

	/**
	 * 新增加一条部门数据
	 */
	@RequestMapping(value = "/addDivn", method = RequestMethod.POST)
	public Object addDept(HttpServletRequest req) {
		return orgnSvc.addDept(req);
	}

	/**
	 * 修改一条部门数据
	 */
	@RequestMapping(value = "/setDivn", method = RequestMethod.POST)
	public Object setDept(HttpServletRequest req) {
		return orgnSvc.setDept(req);
	}

	/**
	 * 删除一条部门数据
	 */
	@RequestMapping(value = "/delDivn", method = RequestMethod.POST)
	public Object delDept(HttpServletRequest req) {
		return orgnSvc.delDept(req);
	}

	/** 员工 */

	/**
	 * 查询员工数据及所在部门的信息一览
	 */
	@RequestMapping(value = "/getEmpList", method = RequestMethod.POST)
	public Object getEmpList(HttpServletRequest req) {
		return orgnSvc.getEmpList(req);
	}

	/**
	 * 根据empId查询一个员工及关联部门的信息
	 */
	@RequestMapping(value = "/getEmpInfo", method = RequestMethod.POST)
	public Object getEmpInfo(HttpServletRequest req) {
		return orgnSvc.getEmpInfo(req);
	}

	/**
	 * 新增加一条员工数据
	 */
	@RequestMapping(value = "/addEmployee", method = RequestMethod.POST)
	public Object addEmployee(HttpServletRequest req) {
		return orgnSvc.addEmployee(req);
	}

	/**
	 * 修改一条员工数据
	 */
	@RequestMapping(value = "/setEmployee", method = RequestMethod.POST)
	public Object setEmployee(HttpServletRequest req) {
		return orgnSvc.setEmployee(req);
	}

	/**
	 * 删除一条员工数据
	 */
	@RequestMapping(value = "/delEmployee", method = RequestMethod.POST)
	public Object delEmployee(HttpServletRequest req) {
		return orgnSvc.delEmployee(req);
	}

	/** 岗位 */

	/**
	 * 查询岗位数据一览
	 */
	@RequestMapping(value = "/getJobList", method = RequestMethod.POST)
	public Object getJobList(HttpServletRequest req) {
		return orgnSvc.getJobList(req);
	}

	/**
	 * 新增加一条岗位数据
	 */
	@RequestMapping(value = "/addJob", method = RequestMethod.POST)
	public Object addJob(HttpServletRequest req) {
		return orgnSvc.addJob(req);
	}

	/**
	 * 修改一条岗位数据
	 */
	@RequestMapping(value = "/setJob", method = RequestMethod.POST)
	public Object setJob(HttpServletRequest req) {
		return orgnSvc.setJob(req);
	}

	/**
	 * 删除一条岗位数据
	 */
	@RequestMapping(value = "/delJob", method = RequestMethod.POST)
	public Object delJob(HttpServletRequest req) {
		return orgnSvc.delJob(req);
	}

	/** 职级 */

	/**
	 * 查询职级数据一览
	 */
	@RequestMapping(value = "/getRankList", method = RequestMethod.POST)
	public Object getRankList(HttpServletRequest req) {
		return orgnSvc.getRankList(req);
	}

	/**
	 * 新增加一条职级数据
	 */
	@RequestMapping(value = "/addRank", method = RequestMethod.POST)
	public Object addRank(HttpServletRequest req) {
		return orgnSvc.addRank(req);
	}

	/**
	 * 修改一条职级数据
	 */
	@RequestMapping(value = "/setRank", method = RequestMethod.POST)
	public Object setRank(HttpServletRequest req) {
		return orgnSvc.setRank(req);
	}

	/**
	 * 删除一条职级数据
	 */
	@RequestMapping(value = "/delRank", method = RequestMethod.POST)
	public Object delRank(HttpServletRequest req) {
		return orgnSvc.delRank(req);
	}

}
