package cn.ps1.soar.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.FlowService;

import javax.servlet.http.HttpServletRequest;

/**
 * 业务流程节点配置管理，重新梳理工作流的定义和配置
 * <p>
 * 支持批量增加删除审批节点
 * 
 * @author Fulin
 * @version 1.0 $Date: 2023.12.30
 * @since openjdk-1.8
 */
@Scope("singleton")
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class FlowController {

	@Autowired
	private FlowService flowSvc;

	/**
	 * 根据流程号（nodeFlowNo）获取一条业务流程树的所有节点
	 */
	@RequestMapping(value = "/getNodeList", method = RequestMethod.POST)
	public Object getNodeList(HttpServletRequest req) {
		return flowSvc.getNodeList(req);
	}

	/**
	 * 新增/编辑一个业务流程树全部工作节点，保存业务流程树结构（nodeFlowNo）
	 */
	@RequestMapping(value = "/saveNodes", method = RequestMethod.POST)
	public Object saveNodes(HttpServletRequest req) {
		return flowSvc.saveNodes(req);
	}

}
