package com.agora.dimensionlibrary;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Button;


import static android.content.Context.WINDOW_SERVICE;

/**
 * Created by manji
 * Date：2018/9/29 下午4:29
 * Desc：
 */
public class WindowUtil {

    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mLayoutParams;
    private WindowManager.LayoutParams mWebLayoutParams;
    private View mView;
    private Button mSwitchBtn ;
    private  WebView mWebView;


    private Point point = new Point();
    private Rect mDeleteRect = new Rect();
    private static final int mViewWidth = 100;
    private static final int mCancelViewSize = 200;
    private int statusBarHeight = 0;

    public static String  token = "";
    public static String  meetingId = "";
    public static String  userId = "";

    private WindowUtil() {

    }

    private static class SingletonInstance {
        @SuppressLint("StaticFieldLeak")
        private static final WindowUtil INSTANCE = new WindowUtil();
    }

    public static WindowUtil getInstance() {
        return SingletonInstance.INSTANCE;
    }

    public void showPermissionWindow(Context context, OnPermissionListener onPermissionListener) {
//        if (RomUtils.checkFloatWindowPermission(context)) {
//            showWindow(context);
//        } else {
//            onPermissionListener.showPermissionDialog();
//        }

        showWindow(context);
    }

    @SuppressLint("CheckResult")
    private void showWindow(Context context) {
        if (null == mWindowManager && null == mView ) {
            mWindowManager = (WindowManager) context.getSystemService(WINDOW_SERVICE);
            mView = LayoutInflater.from(context).inflate(R.layout.bz_button, null);
            mWindowManager.getDefaultDisplay().getSize(point);

              mWebView = (WebView) LayoutInflater.from(context).inflate(R.layout.bz_webview, null);
              mSwitchBtn = mView.findViewById(R.id.aw_iv_btn);

              mSwitchBtn.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if(mWebView.getVisibility()==View.VISIBLE)
                    {
                        mWebView.setVisibility(View.GONE);
                    }else
                    if(mWebView.getVisibility()==View.GONE)
                    {
                        mWebView.setVisibility(View.VISIBLE);
                    }
                }
            });
            mWebView.setBackgroundColor(0);

            mWebView.getBackground().setAlpha(0);
            mWebView.setVerticalScrollBarEnabled(false);
            mWebView.setHorizontalScrollBarEnabled(false);
            WebSettings webSetting = mWebView.getSettings();
            webSetting.setJavaScriptEnabled(true);
            webSetting.setAllowFileAccess(true);
            webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
            webSetting.setSupportZoom(false);
            webSetting.setBuiltInZoomControls(false);
            webSetting.setUseWideViewPort(true);
            webSetting.setSupportMultipleWindows(false);
            webSetting.setLoadWithOverviewMode(true);
            webSetting.setAppCacheEnabled(true);
            webSetting.setDatabaseEnabled(true);
            webSetting.setGeolocationEnabled(true);
            webSetting.setDomStorageEnabled(true);
            webSetting.setAppCacheMaxSize(Long.MAX_VALUE);
           // webSetting.setAppCachePath(getDir("appCache", Context.MODE_PRIVATE).getPath());
            //webSetting.setDatabasePath(getDir("databases", Context.MODE_PRIVATE).getPath());
         //   webSetting.setGeolocationDatabasePath(getDir("geolocation", Context.MODE_PRIVATE).getPath());
            webSetting.setPluginState(WebSettings.PluginState.ON);
            webSetting.setRenderPriority(WebSettings.RenderPriority.HIGH);
            webSetting.setTextSize(WebSettings.TextSize.NORMAL);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                webSetting.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
            }
            mWebView.loadUrl("https://msdk-dev.port2.cn/whiteboard/#/whiteboard?bid="+meetingId+"&token="+token+"&uid="+userId);


            mWebLayoutParams= new WindowManager.LayoutParams();

            initListener(context);

            mLayoutParams = new WindowManager.LayoutParams();

            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
                mLayoutParams.type  = WindowManager.LayoutParams.TYPE_SYSTEM_ALERT;
                mWebLayoutParams.type  = WindowManager.LayoutParams.TYPE_SYSTEM_ALERT;
            } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                mLayoutParams.type  = WindowManager.LayoutParams.TYPE_ACCESSIBILITY_OVERLAY;
                mWebLayoutParams.type  = WindowManager.LayoutParams.TYPE_ACCESSIBILITY_OVERLAY;
            } else {
                mLayoutParams.type = WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY;
                mWebLayoutParams.type = WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY;
            }



            mWebLayoutParams.format = PixelFormat.RGBA_8888;   //窗口透明
            mWebLayoutParams.gravity = Gravity.LEFT | Gravity.TOP;  //窗口位置
            mWebLayoutParams.flags = WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL | WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE|WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE;;
            mWebLayoutParams.width = DisplayUtil.getScreenWidth(context);
            mWebLayoutParams.height = DisplayUtil.getScreenHeight(context);
            // 可以修改View的初始位置
//            mLayoutParams.x = 0;
//            mLayoutParams.y = 0;
            mWindowManager.addView(mWebView, mWebLayoutParams);


            mLayoutParams.format = PixelFormat.RGBA_8888;   //窗口透明
            mLayoutParams.gravity = Gravity.LEFT | Gravity.TOP;  //窗口位置
            mLayoutParams.flags = WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL | WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE;
            mLayoutParams.width = 200;
            mLayoutParams.height =200;
            // 可以修改View的初始位置
//            mLayoutParams.x = 0;
//            mLayoutParams.y = 0;
            mWindowManager.addView(mView, mLayoutParams);

            mWebView.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View view, MotionEvent motionEvent) {
                    return true;
                }
            });

        }
    }

    public void dismissWindow() {
        if (mWindowManager != null && mView != null) {
            mWindowManager.removeViewImmediate(mView);
            mWindowManager = null;

            mView = null;

        }
    }


    private void initListener(final Context context) {
//        mView.setOnClickListener(v -> {
//            String jumpUrl = SPUtil.getStringDefault(WebViewActivity.ARTICLE_JUMP_URL, "");
//            if (!jumpUrl.isEmpty()) {
//                WebViewActivity.start(context, jumpUrl);
//            }
//        });

        final int mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = context.getResources().getDimensionPixelSize(resourceId);
        }
//        //设置触摸滑动事件
//        mView.setOnTouchListener(new View.OnTouchListener() {
//
//
//            @SuppressLint("ClickableViewAccessibility")
//            @Override
//            public boolean onTouch(View v, MotionEvent event) {
//
//                return false;
//            }
//
//
//        });
    }



    public void hideWindow() {
        if (mView != null) {
            mView.setVisibility(View.GONE);
        }

    }

    public void visibleWindow() {
        if (mView != null) {
            mView.setVisibility(View.VISIBLE);
        }

    }

    interface OnPermissionListener {
        void showPermissionDialog();
    }
}