package com.agora.dimensionlibrary;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

public class DimensionLayout extends RelativeLayout {
    public DimensionLayout(Context context) {
        super(context);
    }

    public DimensionLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DimensionLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public DimensionLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public interface DimensionLayoutChangeLayoutListener{
       void onLayoutChange(int width,int height);
    }



    public void setChangeLayoutListener(DimensionLayoutChangeLayoutListener changeLayoutListener) {
        this.changeLayoutListener = changeLayoutListener;
    }

    private DimensionLayoutChangeLayoutListener changeLayoutListener;

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if(changeLayoutListener!=null)
        {
            changeLayoutListener.onLayoutChange(getWidth(),getHeight());
        }
    }
}
