package com.agora.dimensionlibrary;

import android.app.Activity;
import android.os.Build;
import android.os.Handler;

import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;

import com.google.gson.Gson;
import com.google.gson.JsonObject;

import java.io.IOException;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
public class DimensionClient {



    public void init(String uri, String ticket, String userId,String appid,DimensionInitializeListener initializeListener) {
        if(!this.isInit)
        {

            this.uri = uri;
            this.userId = userId;
            this.appid = appid;


            String url = uri+ "/board-api/user/login";
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("userid",userId);
            jsonObject.addProperty("did", "test");
            jsonObject.addProperty("ticket", ticket);
            sendPost(jsonObject, url, new HttpListener() {
                @Override
                public void onError(String error) {
                    if(initializeListener!=null)
                    {
                        initializeListener.callback(-1);
                    }

                }

                @Override
                public void onSuccess(JsonObject data) {
                    token = data.get("userToken").getAsString();
                    isInit = true;
                    if(initializeListener!=null)
                    {
                        initializeListener.callback(0);
                    }

                }
            });
        }

    }
    private static void sendPost(JsonObject postJson, String url, HttpListener httpListener) {
        String json = postJson.toString();
        OkHttpClient okHttpClient = new OkHttpClient();
        RequestBody body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), json);
        Request request = new Request.Builder().post(body).url(url).build();

        Call call = okHttpClient.newCall(request);
        call.enqueue(new Callback() {
            @Override
            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                if (httpListener != null) {
                    httpListener.onError(e.getMessage());
                }
            }

            @Override
            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                JsonObject data = new Gson().fromJson(response.body().string(), JsonObject.class);
                if (data.get("errcode").getAsInt() == 0) {
                    if (httpListener != null) {
                        httpListener.onSuccess(data);
                    }
                } else {
                    if (httpListener != null) {
                        httpListener.onError(data.get("errmsg").getAsString());
                    }
                }
            }
        });
    }
    public interface HttpListener {
        void onError(String error);

        void onSuccess(JsonObject data);
    }

    private static DimensionClient instance;
    private boolean isInit;
    private String uri;
    private WebView mWebView;



    public void startDimension() {

        if (mWebView!=null)
        {
            isClose = false;
            mWebView.loadUrl("javascript:ow()");
        }


    }





    private String appid;
    private String token;
    private int parentHeight;
    private int parentWidth;


    private String userId;
    private boolean isClose = false;

    private int height;
    private int width;

    public static synchronized DimensionClient getInstance() {
        if (instance == null) {
            instance = new DimensionClient();
        }

        return instance;
    }

    public boolean isClose()
    {
        if (mWebView==null)
        {
            return true;
        }

        return isClose;
    }


    public boolean isHidden()
    {
        if(mWebView!=null)
        {
            return  mWebView.getVisibility()== View.VISIBLE ;
        }
        return false;
    }

    public void setHidden(boolean hidden)
    {
        if(mWebView!=null)
        {
            mWebView.setVisibility(hidden?View.GONE:View.VISIBLE);
        }
    }

    public void removeView()
    {
        this.width = -1;
        this.height = -1;


        if(mWebView!=null&& mWebView.getParent()!=null)
        {
            ((ViewGroup) mWebView.getParent()).removeView(mWebView);
            mWebView = null;
        }
        if (parentView !=null)
        {
            parentView.setChangeLayoutListener(null);
            parentView = null;
        }
    }
    private class JsInterface {
        @JavascriptInterface
        public void cw(String param) {
            isClose = true;


        }
        @JavascriptInterface
        public void destroy(String param) {
            DimensionClient.getInstance().destroy();

        }
    }
    DimensionLayout  parentView;
    public int bindView(DimensionLayout  view,String bid)
    {
        if(mWebView!=null)
        {
            return -1;
        }
        isClose = false;

        mWebView = (WebView) LayoutInflater.from(view.getContext()).inflate(R.layout.bz_webview, null);
        mWebView.setBackgroundColor(0);

        mWebView.getBackground().setAlpha(0);
        mWebView.setVerticalScrollBarEnabled(false);
        mWebView.setHorizontalScrollBarEnabled(false);
        mWebView.setWebViewClient(new WebViewClient(){
            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                handler.sendEmptyMessage(0);
            }
        });
        WebSettings webSetting = mWebView.getSettings();
        webSetting.setJavaScriptEnabled(true);
        webSetting.setAllowFileAccess(true);
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        webSetting.setSupportZoom(false);
        webSetting.setBuiltInZoomControls(false);
        webSetting.setUseWideViewPort(true);
        webSetting.setSupportMultipleWindows(false);
        webSetting.setLoadWithOverviewMode(true);
        webSetting.setAppCacheEnabled(true);
        webSetting.setDatabaseEnabled(true);
        webSetting.setGeolocationEnabled(true);
        webSetting.setDomStorageEnabled(true);
        webSetting.setAppCacheMaxSize(Long.MAX_VALUE);
        webSetting.setPluginState(WebSettings.PluginState.ON);
        webSetting.setRenderPriority(WebSettings.RenderPriority.HIGH);
        webSetting.setTextSize(WebSettings.TextSize.NORMAL);


        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            webSetting.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT,  RelativeLayout.LayoutParams.MATCH_PARENT );
        view.addView(mWebView,layoutParams);
        String url = this.uri+"/whiteboard/#/whiteboard?bid="+bid+"&token="+token+"&uid="+userId+"&appid="+this.appid;
        mWebView.loadUrl( url);
        mWebView.addJavascriptInterface(new JsInterface(), "jsInterface");
        parentView = view;
        parentView.setChangeLayoutListener(new DimensionLayout.DimensionLayoutChangeLayoutListener() {
            @Override
            public void onLayoutChange(int width, int height) {
                DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();

                parentHeight = (int) (height/displayMetrics.density);
                parentWidth = (int) (width/displayMetrics.density);
                handler.sendEmptyMessage(0);
            }
        });


        mWebView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                return isClose;
            }
        });
        return 0;
    }


    public void destroy(){

        this.isInit = false;
        this.appid = null;
        this.token = null;
        this.userId = null;
        isClose = false;
        removeView();
    }
    Handler handler = new Handler(Looper.getMainLooper(),new Handler.Callback() {
        @Override
        public boolean handleMessage(@NonNull Message message) {
            if(mWebView!=null)
            {
                float scale = (float) width/(float) height;
                float aWidth = 0.0f;
                float aHeight = 0.0f;

                if (parentWidth<parentHeight)
                {

                    aWidth = parentWidth;
                    aHeight = aWidth/scale;
                }else{
                    aHeight = parentHeight;
                    aWidth = aHeight*scale;

                }
               String cmd = "javascript:resize("+ (int)aWidth+","+  (int)aHeight +")";


                mWebView.loadUrl(cmd);
            }

            return false;
        }
    });
    public void updateSize(int width, int height) {
        if(width!=this.width||height!=this.height)
        {
            this.width = width;
            this.height = height;
            if(mWebView!=null)
            {

                handler.sendEmptyMessage(0);
            }

        }

    }
}
