/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.consul.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetUtil {
    private static final Logger log = LoggerFactory.getLogger(InetUtil.class);

    public static InetAddress findFirstNonLoopbackAddress(List<String> preferredAddress) {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                log.trace("Testing interface: " + ifc.getDisplayName());
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress() || !InetUtil.isPreferredAddress(address, preferredAddress)) continue;
                    log.trace("Found non-loopback interface: " + ifc.getDisplayName());
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            log.error("Cannot get first non-loopback address", (Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.warn("Unable to retrieve localhost");
            return null;
        }
    }

    static boolean isPreferredAddress(InetAddress address, List<String> preferredAddress) {
        if (preferredAddress == null) {
            return true;
        }
        for (String regex : preferredAddress) {
            String hostAddress = address.getHostAddress();
            if (!hostAddress.matches(regex) && !hostAddress.startsWith(regex)) continue;
            return true;
        }
        log.trace("Ignoring address: " + address.getHostAddress());
        return false;
    }
}

