/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.consul.http;

import cn.pomit.consul.http.HttpResponseMessage;
import cn.pomit.consul.http.res.ResCode;
import cn.pomit.consul.http.res.ResType;
import com.alibaba.fastjson.util.TypeUtils;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpRequestMessage
extends DefaultHttpRequest {
    private Map<String, Object> params = null;
    private ByteBuf content = null;
    private String url = "";
    private HttpRequest hr = null;
    private Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private HttpResponseMessage hrm = new HttpResponseMessage();
    private Charset charset = Charset.defaultCharset();

    public HttpRequestMessage(HttpVersion httpVersion, HttpMethod method, String uri) {
        super(httpVersion, method, uri);
        this.hr = this;
    }

    public HttpRequestMessage(DefaultHttpRequest defaultHttpRequest) {
        super(defaultHttpRequest.protocolVersion(), defaultHttpRequest.method(), defaultHttpRequest.uri(), defaultHttpRequest.headers());
        this.hr = defaultHttpRequest;
    }

    public HttpRequestMessage(DefaultHttpRequest defaultHttpRequest, Map<String, Object> params) {
        super(defaultHttpRequest.protocolVersion(), defaultHttpRequest.method(), defaultHttpRequest.uri(), defaultHttpRequest.headers());
        this.params = params;
    }

    public HttpRequestMessage(HttpRequest hr) {
        super(hr.protocolVersion(), hr.method(), hr.uri(), hr.headers());
        this.hr = hr;
    }

    public Object getParameter(String key) {
        return this.params.get(key);
    }

    public String getParameterString(String key) {
        return this.params.get(key) == null ? null : this.params.get(key).toString();
    }

    public int getParameterInt(String key) {
        return (Integer)TypeUtils.cast((Object)this.params.get(key), Integer.TYPE, null);
    }

    public boolean getParameterBoolean(String key) {
        return (Boolean)TypeUtils.cast((Object)this.params.get(key), Boolean.TYPE, null);
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getContent() {
        return this.content.toString(this.charset);
    }

    public ByteBuf getBody() {
        return this.content;
    }

    public void setContent(ByteBuf content) {
        this.content = content;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HttpResponseMessage getReponse() {
        return this.hrm;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpResponseMessage getReponse(ResCode resCode, ResType resType, String message) {
        this.hrm.setResCode(resCode.getValue());
        this.hrm.setResType(resType.getValue());
        this.hrm.setMessage(message);
        return this.hrm;
    }

    public void parseRequest() {
        try {
            Set cookiesSet;
            URI uri = new URI(this.uri());
            this.setUrl(uri.getPath());
            String cookieStr = this.headers().get("Cookie");
            if (!StringUtil.isNullOrEmpty((String)cookieStr) && (cookiesSet = ServerCookieDecoder.LAX.decode(cookieStr)) != null && cookiesSet.size() > 0) {
                for (Cookie cookie : cookiesSet) {
                    this.cookies.put(cookie.name(), cookie);
                }
            }
            if (uri.getQuery() != null && !"".equals(uri.getQuery())) {
                Map<String, Object> params = this.createGetParamMap(uri.getQuery());
                this.setParams(params);
            }
            if (this.params == null) {
                this.params = new HashMap<String, Object>();
            }
            if (this.hr instanceof FullHttpRequest) {
                FullHttpRequest request = (FullHttpRequest)this.hr;
                this.setContent(request.content());
                String contentTypeValue = this.hr.headers().get("Content-Type");
                if (!StringUtil.isNullOrEmpty((String)contentTypeValue) && contentTypeValue.contains("application/json")) {
                    return;
                }
                HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)new DefaultHttpDataFactory(false), (HttpRequest)request);
                List postData = decoder.getBodyHttpDatas();
                for (InterfaceHttpData data : postData) {
                    if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                    MemoryAttribute attribute = (MemoryAttribute)data;
                    String value = attribute.getValue();
                    this.params.put(attribute.getName(), value);
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> createGetParamMap(String query) {
        int index = -1;
        index = query.indexOf(";");
        if (index != -1) {
            String cookieStr = query.substring(index + 1);
            Set cookiesSet = ServerCookieDecoder.LAX.decode(cookieStr);
            if (cookiesSet != null && cookiesSet.size() > 0) {
                for (Cookie cookie : cookiesSet) {
                    this.cookies.put(cookie.name(), cookie);
                }
            }
            query = query.substring(0, index);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String[] querys = query.split("&");
        for (int i = 0; i < querys.length; ++i) {
            String paramQuery = querys[i];
            String[] map = paramQuery.split("=", 2);
            if (map == null || map.length != 2) continue;
            params.put(map[0], map[1]);
        }
        return params;
    }

    public String toString() {
        return "HttpRequestMessage [url=" + this.url + "]; method=" + this.method().name();
    }
}

