/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.consul.handler.factory;

import cn.pomit.consul.annotation.Mapping;
import cn.pomit.consul.annotation.Value;
import cn.pomit.consul.config.ApplicationProperties;
import cn.pomit.consul.handler.ResourceServerHandler;
import cn.pomit.consul.handler.method.HandlerMethod;
import cn.pomit.consul.handler.resource.AbstractResourceHandler;
import cn.pomit.consul.util.ReflectUtil;
import com.alibaba.fastjson.util.TypeUtils;
import io.netty.util.internal.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHandlerFactory {
    protected static Logger log = LoggerFactory.getLogger(ResourceHandlerFactory.class);

    public static ResourceServerHandler createResourceServerHandler(ApplicationProperties applicationProperties) throws Exception {
        ResourceServerHandler resourceHandler = ResourceServerHandler.getInstance();
        return resourceHandler;
    }

    public static void initValues(AbstractResourceHandler resourceHandler, ApplicationProperties applicationProperties) throws Exception {
        Field[] fields;
        log.info("\u521d\u59cb\u5316{}\u7684@Value\u6ce8\u89e3\u3002\u3002\u3002", (Object)resourceHandler);
        for (Field field : fields = resourceHandler.getClass().getDeclaredFields()) {
            Value value = field.getAnnotation(Value.class);
            if (value == null) continue;
            Class<?> type = field.getType();
            String fieldName = field.getName();
            if (!ReflectUtil.isJavaClass(type)) continue;
            Method setMethod = resourceHandler.getClass().getMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), type);
            String param = applicationProperties.getString(value.value());
            if (StringUtil.isNullOrEmpty((String)param)) continue;
            setMethod.invoke((Object)resourceHandler, TypeUtils.cast((Object)param, type, null));
        }
    }

    public static void initMethodHandlers(AbstractResourceHandler resourceHandler) {
        log.info("\u521d\u59cb\u5316{}@Mapping\u6ce8\u89e3\u3002\u3002\u3002", (Object)resourceHandler);
        Method[] methods = resourceHandler.getClass().getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Mapping mapping = methods[j].getAnnotation(Mapping.class);
            if (mapping == null) continue;
            String methodValue = mapping.value();
            if ("".equals(methodValue)) {
                methodValue = "/" + methods[j].getName();
            } else if (!methodValue.startsWith("/")) {
                methodValue = "/" + methodValue;
            }
            if (methodValue.contains("**")) {
                String[] param = methodValue.split("\\*\\*");
                HandlerMethod handlerMethod = new HandlerMethod();
                handlerMethod.setMethod(methods[j]);
                handlerMethod.setResourceHandler(resourceHandler);
                ResourceServerHandler.getElMethod().put(param[0], handlerMethod);
                continue;
            }
            HandlerMethod handlerMethod = new HandlerMethod();
            handlerMethod.setMethod(methods[j]);
            handlerMethod.setResourceHandler(resourceHandler);
            ResourceServerHandler.getNormalMethod().put(methodValue, handlerMethod);
        }
    }
}

