/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.consul.handler.codec;

import cn.pomit.consul.http.HttpResponseMessage;
import cn.pomit.consul.http.res.ResCode;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.List;

public class FullHttpResponseEncoder
extends MessageToMessageEncoder<HttpResponseMessage> {
    private String charset;

    public FullHttpResponseEncoder(String charset) {
        this.charset = charset;
    }

    protected void encode(ChannelHandlerContext ctx, HttpResponseMessage message, List<Object> out) throws Exception {
        try {
            if (message.getMessage() == null) {
                message.setMessage("");
            }
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)message.getResCode()), Unpooled.wrappedBuffer((byte[])message.getMessage().getBytes(this.charset)));
            response.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(message.getResType() + ";charset=" + this.charset));
            response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
            if (message.getHeaders() != null && message.getHeaders().size() > 0) {
                for (HttpHeaders headers : message.getHeaders()) {
                    response.headers().add(headers);
                }
            }
            if (message.getEncodedCookie() != null && message.getEncodedCookie().size() > 0) {
                for (String cookie : message.getEncodedCookie()) {
                    response.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)cookie);
                }
            }
            if (message.getResCode() == ResCode.REDIRECT.getValue()) {
                response.headers().add((CharSequence)HttpHeaderNames.LOCATION, (Object)message.getRedirectUrl());
            }
            out.add(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

