/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.consul.handler;

import cn.pomit.consul.handler.ResourceServerHandler;
import cn.pomit.consul.http.HttpRequestMessage;
import cn.pomit.consul.http.HttpResponseMessage;
import cn.pomit.consul.http.res.ResCode;
import cn.pomit.consul.http.res.ResType;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private ResourceServerHandler resourceHandler = null;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public HttpServerHandler(ResourceServerHandler resourceHandler) {
        this.resourceHandler = resourceHandler;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        try {
            HttpRequest httpRequest = (HttpRequest)msg;
            HttpRequestMessage httpRequestMessage = new HttpRequestMessage(httpRequest);
            httpRequestMessage.parseRequest();
            this.log.trace("\u6536\u5230\u8bf7\u6c42\uff1a" + httpRequestMessage.getUrl());
            HttpResponseMessage httpResponseMessage = httpRequestMessage.getReponse();
            httpResponseMessage = this.resourceHandler.handle(httpRequestMessage);
            if (httpResponseMessage == null) {
                this.log.error("\u672a\u627e\u5230\u76f8\u5e94\u7684\u8def\u5f84\u6620\u5c04\u4fe1\u606f\uff01");
                httpResponseMessage = new HttpResponseMessage();
                httpResponseMessage.setResType(ResType.TEXT.getValue());
                httpResponseMessage.setResCode(ResCode.INTERNAL_ERROR.getValue());
                httpResponseMessage.setMessage("\u672a\u627e\u5230\u76f8\u5e94\u7684\u8def\u5f84\u6620\u5c04\u4fe1\u606f\uff01");
            }
            this.log.trace("\u54cd\u5e94\u6570\u636e\uff1a" + httpResponseMessage);
            ctx.writeAndFlush((Object)httpResponseMessage);
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.error(e.getStackTrace()[0] + "---" + e.getMessage());
            HttpResponseMessage httpResponseMessage = new HttpResponseMessage();
            httpResponseMessage.setResType(ResType.TEXT.getValue());
            httpResponseMessage.setResCode(ResCode.INTERNAL_ERROR.getValue());
            httpResponseMessage.setMessage("\u5f02\u5e38\u629b\u51fa\uff1a" + e.getMessage());
            ctx.writeAndFlush((Object)httpResponseMessage);
            return;
        }
    }
}

