/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.consul.endpoint;

import cn.pomit.consul.config.ApplicationProperties;
import cn.pomit.consul.discovery.ConsulRegister;
import cn.pomit.consul.handler.HttpServerHandler;
import cn.pomit.consul.handler.ResourceServerHandler;
import cn.pomit.consul.handler.codec.FullHttpResponseEncoder;
import cn.pomit.consul.handler.resource.AbstractResourceHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyServerTemplate {
    protected List<Class<? extends AbstractResourceHandler>> resourceHandlerList = null;
    private static int httpIdleTime = 120;
    protected Integer port = null;
    protected String name = null;
    public static String DEFAULT_NAME = "JsonServer";
    protected static String PROPERTIES_NAME = "application.properties";
    protected String charset = "UTF-8";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static EventLoopGroup bossGroup = new NioEventLoopGroup();
    private static EventLoopGroup workerGroup = new NioEventLoopGroup();
    protected ApplicationProperties consulProperties = null;
    protected ResourceServerHandler resourceServerHandler = null;

    NettyServerTemplate() {
    }

    protected ChannelHandler[] createHandlers() throws Exception {
        this.resourceServerHandler = this.resourceHandler();
        return new ChannelHandler[]{new IdleStateHandler(0, 0, httpIdleTime), new HttpResponseEncoder(), new HttpRequestDecoder(), new HttpObjectAggregator(0x100000), new FullHttpResponseEncoder(this.charset), new HttpServerHandler(this.resourceServerHandler)};
    }

    public void start() throws Exception {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelHandler[] handlers;
                for (ChannelHandler handler : handlers = NettyServerTemplate.this.createHandlers()) {
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        ChannelFuture cf = b.bind(this.port.intValue()).await();
        if (!cf.isSuccess()) {
            this.log.error("\u65e0\u6cd5\u7ed1\u5b9a\u7aef\u53e3\uff1a{}", (Object)this.port);
            throw new Exception("\u65e0\u6cd5\u7ed1\u5b9a\u7aef\u53e3\uff1a" + this.port);
        }
        this.log.info("server\u542f\u52a8\u5b8c\u6bd5\uff0c\u5f00\u59cb\u6ce8\u518c\u670d\u52a1");
        ConsulRegister consulRegister = new ConsulRegister(this.consulProperties);
        consulRegister.register();
        this.log.info("\u670d\u52a1[{}]\u542f\u52a8\u5b8c\u6bd5\uff0c\u76d1\u542c\u7aef\u53e3[{}]", (Object)this.name, (Object)this.port);
    }

    public void stop() {
        bossGroup.shutdownGracefully().syncUninterruptibly();
        workerGroup.shutdownGracefully().syncUninterruptibly();
        this.log.info("\u670d\u52a1[{}]\u5173\u95ed\u3002", (Object)this.name);
    }

    public void setResourceHandlers(Class<? extends AbstractResourceHandler>[] resourceHandler) throws Exception {
        this.resourceHandlerList = Arrays.asList(resourceHandler);
        ResourceServerHandler.initInstance(this.resourceHandlerList, this.consulProperties);
    }

    protected abstract ResourceServerHandler resourceHandler() throws Exception;
}

