/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.consul.discovery;

import cn.pomit.consul.config.ApplicationProperties;
import com.ecwid.consul.ConsulException;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulRegister {
    private ApplicationProperties consulProperties = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ConsulRegister(ApplicationProperties consulProperties) {
        this.consulProperties = consulProperties;
    }

    public void register() {
        this.log.info("\u6ce8\u518c\u670d\u52a1\u5230:{}:{}", (Object)this.consulProperties.getHost(), (Object)this.consulProperties.getPort());
        ConsulClient client = new ConsulClient(this.consulProperties.getHost(), this.consulProperties.getPort());
        NewService service = new NewService();
        service.setId(this.consulProperties.getInstanceId());
        service.setAddress(this.consulProperties.getHostname());
        service.setName(this.consulProperties.getApplicationName());
        service.setTags(this.createTags());
        service.setPort(Integer.valueOf(this.consulProperties.getApplicationPort()));
        this.setCheck(service);
        try {
            client.agentServiceRegister(service);
        }
        catch (ConsulException e) {
            this.log.warn("Error registering service with consul: " + service, (Throwable)e);
        }
        client.agentServiceRegister(service);
        this.log.info("\u670d\u52a1\u5df2\u6ce8\u518c\uff1a{}", (Object)service);
    }

    private void setCheck(NewService service) {
        NewService.Check check = new NewService.Check();
        String healthCheckUrl = this.consulProperties.getHealthCheckUrl();
        check.setHttp(healthCheckUrl);
        check.setInterval(this.consulProperties.getHealthCheckInterval());
        check.setTimeout(this.consulProperties.getHealthCheckTimeout());
        service.setCheck(check);
    }

    private List<String> createTags() {
        LinkedList<String> tags = new LinkedList<String>(this.consulProperties.getTags());
        tags.add("secure=" + this.consulProperties.getScheme().equalsIgnoreCase("https"));
        return tags;
    }
}

