/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.consul.config;

import cn.pomit.consul.config.Source;
import cn.pomit.consul.endpoint.NettyServerTemplate;
import cn.pomit.consul.util.InetUtil;
import io.netty.util.internal.StringUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class ApplicationProperties {
    public static String DEFAULT_IP = "127.0.0.1";
    public static String DEFAULT_PORT = "8500";
    public static String DEFAULT_APP_PORT = "8080";
    public static String DEFAULT_SCHEME = "http";
    public static String DEFAULT_HEALTHCHECK_PATH = "/actuator/health";
    private String host;
    private int port = 8500;
    private String applicationName;
    private int applicationPort;
    private String ipAddress;
    private String hostname;
    private boolean preferIpAddress = false;
    private List<String> tags = new ArrayList<String>();
    private String healthCheckPath = "/actuator/health";
    private String healthCheckUrl;
    private String healthCheckInterval = "10s";
    private String healthCheckTimeout;
    private String instanceId;
    private String scheme;
    private Properties serverProperties = new Properties();

    public ApplicationProperties(Properties serverProperties, Integer serverPort) {
        this.serverProperties = serverProperties;
        this.host = serverProperties.getProperty("consul.host", DEFAULT_IP);
        this.port = Integer.parseInt(serverProperties.getProperty("consul.port", DEFAULT_PORT));
        this.applicationPort = serverPort == null ? Integer.parseInt(serverProperties.getProperty("application.port", DEFAULT_APP_PORT)) : serverPort;
        this.applicationName = serverProperties.getProperty("application.name", NettyServerTemplate.DEFAULT_NAME);
        String instanceId = serverProperties.getProperty("consul.instanceId");
        if (StringUtil.isNullOrEmpty((String)instanceId)) {
            instanceId = this.applicationName + "-" + this.applicationPort;
        }
        this.instanceId = instanceId;
        this.scheme = serverProperties.getProperty("consul.scheme", DEFAULT_SCHEME);
        this.preferIpAddress = Boolean.parseBoolean(serverProperties.getProperty("consul.preferIpAddress", "false"));
        InetAddress inetAddress = InetUtil.findFirstNonLoopbackAddress(null);
        this.ipAddress = inetAddress.getHostAddress();
        this.hostname = inetAddress.getHostName();
        this.healthCheckUrl = serverProperties.getProperty("consul.healthCheckUrl");
        this.healthCheckInterval = serverProperties.getProperty("consul.healthCheckInterval", "10s");
        this.healthCheckTimeout = serverProperties.getProperty("consul.healthCheckTimeout");
        if (StringUtil.isNullOrEmpty((String)this.healthCheckUrl)) {
            this.healthCheckPath = serverProperties.getProperty("consul.healthCheckPath", DEFAULT_HEALTHCHECK_PATH);
            this.healthCheckUrl = String.format("%s://%s:%s%s", this.scheme, this.getHostname(), this.applicationPort, this.healthCheckPath);
        }
    }

    public ApplicationProperties(List<Source> sourceList, Integer serverPort) {
        if (serverPort != null && serverPort > 0) {
            this.serverProperties.put("application.port", serverPort);
        }
        if (sourceList != null && sourceList.size() > 0) {
            for (int i = sourceList.size() - 1; i >= 0; --i) {
                Source source = sourceList.get(i);
                for (Object key : source.keySet()) {
                    this.serverProperties.put(key, source.getProperty((String)key));
                }
            }
        }
        this.host = this.serverProperties.getProperty("consul.host", DEFAULT_IP);
        this.port = Integer.parseInt(this.serverProperties.getProperty("consul.port", DEFAULT_PORT));
        this.applicationPort = Integer.parseInt(this.serverProperties.getProperty("application.port", DEFAULT_APP_PORT));
        this.applicationName = this.serverProperties.getProperty("application.name", NettyServerTemplate.DEFAULT_NAME);
        String instanceId = this.serverProperties.getProperty("consul.instanceId");
        if (StringUtil.isNullOrEmpty((String)instanceId)) {
            instanceId = this.applicationName + "-" + this.applicationPort;
        }
        this.instanceId = instanceId;
        this.scheme = this.serverProperties.getProperty("consul.scheme", DEFAULT_SCHEME);
        this.preferIpAddress = Boolean.parseBoolean(this.serverProperties.getProperty("consul.preferIpAddress", "false"));
        InetAddress inetAddress = InetUtil.findFirstNonLoopbackAddress(null);
        this.ipAddress = inetAddress.getHostAddress();
        this.hostname = inetAddress.getHostName();
        this.healthCheckUrl = this.serverProperties.getProperty("consul.healthCheckUrl");
        this.healthCheckInterval = this.serverProperties.getProperty("consul.healthCheckInterval", "10s");
        this.healthCheckTimeout = this.serverProperties.getProperty("consul.healthCheckTimeout");
        if (StringUtil.isNullOrEmpty((String)this.healthCheckUrl)) {
            this.healthCheckPath = this.serverProperties.getProperty("consul.healthCheckPath", DEFAULT_HEALTHCHECK_PATH);
            this.healthCheckUrl = String.format("%s://%s:%s%s", this.scheme, this.getHostname(), this.applicationPort, this.healthCheckPath);
        }
    }

    public String getHostname() {
        return this.preferIpAddress ? this.ipAddress : this.hostname;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getApplicationPort() {
        return this.applicationPort;
    }

    public void setApplicationPort(int applicationPort) {
        this.applicationPort = applicationPort;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getHealthCheckPath() {
        return this.healthCheckPath;
    }

    public boolean isHealthCheckPath(String url) {
        if (StringUtil.isNullOrEmpty((String)this.healthCheckPath)) {
            return false;
        }
        return this.healthCheckPath.equals(url);
    }

    public void setHealthCheckPath(String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
    }

    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    public void setHealthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl;
    }

    public String getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public void setHealthCheckInterval(String healthCheckInterval) {
        this.healthCheckInterval = healthCheckInterval;
    }

    public String getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public void setHealthCheckTimeout(String healthCheckTimeout) {
        this.healthCheckTimeout = healthCheckTimeout;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getString(String key) {
        return this.serverProperties.getProperty(key);
    }

    public int getInt(String key) {
        String value = this.serverProperties.getProperty(key);
        if (StringUtil.isNullOrEmpty((String)value)) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public boolean getBoolean(String key) {
        String value = this.serverProperties.getProperty(key);
        if (StringUtil.isNullOrEmpty((String)value)) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public List<String> getList(String key) {
        String value = this.serverProperties.getProperty(key);
        if (StringUtil.isNullOrEmpty((String)value)) {
            return null;
        }
        List<String> list = Arrays.asList(value.split(","));
        return list;
    }

    public Properties getServerProperties() {
        return this.serverProperties;
    }

    public void setServerProperties(Properties serverProperties) {
        this.serverProperties = serverProperties;
    }
}

