/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.consul;

import cn.pomit.consul.annotation.EnableMybatis;
import cn.pomit.consul.annotation.EnableServer;
import cn.pomit.consul.annotation.InitConfiguration;
import cn.pomit.consul.config.ApplicationProperties;
import cn.pomit.consul.config.DefaultSource;
import cn.pomit.consul.config.PropertySource;
import cn.pomit.consul.config.Source;
import cn.pomit.consul.endpoint.JsonHttpServer;
import cn.pomit.consul.util.PropertyUtil;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulProxyApplication {
    protected static String PROPERTIES_NAME = "application.properties";
    protected static String PROPERTIES_ENV_NAME = "application-%s.properties";
    protected static String SPRING_ENV = "spring.profiles.active";
    protected static String APPLICATION_ENV = "profiles.active";
    protected static String SERVER_PORT = "server.port";
    protected static String APPLICATION_PORT = "application.port";
    protected static String DATABASE_CONFIG_CLASS = "mybatis.configuration";
    private static Logger log = LoggerFactory.getLogger(ConsulProxyApplication.class);

    public static void run(Class<?> app, String[] args) {
        block10: {
            try {
                InitConfiguration initConfiguration;
                List<Source> sourceList = ConsulProxyApplication.initProperties(args);
                EnableServer jsonServer = app.getAnnotation(EnableServer.class);
                int port = jsonServer.port();
                ApplicationProperties consulProperties = new ApplicationProperties(sourceList, (Integer)port);
                JsonHttpServer defaultJsonServer = new JsonHttpServer(consulProperties);
                defaultJsonServer.setResourceHandlers(jsonServer.handler());
                defaultJsonServer.start();
                EnableMybatis enableMybatis = app.getAnnotation(EnableMybatis.class);
                if (enableMybatis != null) {
                    Method initConfiguration2;
                    String className = consulProperties.getString(DATABASE_CONFIG_CLASS);
                    if (StringUtil.isNullOrEmpty((String)className)) {
                        log.error("\u672a\u627e\u5230myabtsi\u7684\u914d\u7f6e\u4fe1\u606f");
                        throw new Exception("\u672a\u627e\u5230myabtsi\u7684\u914d\u7f6e\u4fe1\u606f");
                    }
                    Class<?> cls = Class.forName(className);
                    String mapperScan = enableMybatis.mapperScan();
                    if (!StringUtil.isNullOrEmpty((String)mapperScan)) {
                        initConfiguration2 = cls.getMethod("initConfiguration", String.class, Properties.class);
                        initConfiguration2.invoke(null, mapperScan, consulProperties.getServerProperties());
                    } else {
                        initConfiguration2 = cls.getMethod("initConfiguration", Properties.class);
                        initConfiguration2.invoke(null, consulProperties.getServerProperties());
                    }
                }
                if ((initConfiguration = app.getAnnotation(InitConfiguration.class)) == null || initConfiguration.configurations().length <= 0) break block10;
                for (Class<?> cls : initConfiguration.configurations()) {
                    Method initMethod;
                    block11: {
                        initMethod = null;
                        try {
                            initMethod = cls.getMethod("initConfiguration", new Class[0]);
                        }
                        catch (Exception e) {
                            if (initMethod != null) break block11;
                            initMethod = cls.getMethod("initConfiguration", Properties.class);
                        }
                    }
                    if (initMethod == null) continue;
                    initMethod.invoke(null, consulProperties.getServerProperties());
                }
            }
            catch (IOException e) {
                log.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static List<Source> initProperties(String[] args) throws IOException {
        PropertySource propertySource;
        ArrayList<Source> list = new ArrayList<Source>();
        DefaultSource defaultSource = new DefaultSource();
        for (String arg : args) {
            String optionName;
            if (!arg.startsWith("--")) continue;
            String optionText = arg.substring(2, arg.length());
            String optionValue = null;
            if (optionText.contains("=")) {
                optionName = optionText.substring(0, optionText.indexOf(61));
                optionValue = optionText.substring(optionText.indexOf(61) + 1, optionText.length());
            } else {
                optionName = optionText;
            }
            if (optionName.isEmpty() || optionValue != null && optionValue.isEmpty()) {
                throw new IllegalArgumentException("Invalid argument syntax: " + arg);
            }
            defaultSource.setProperty(optionName, optionValue);
        }
        if (defaultSource.getProperty(SERVER_PORT) != null) {
            defaultSource.setProperty(APPLICATION_PORT, defaultSource.getProperty(SERVER_PORT));
        }
        list.add(defaultSource);
        Properties properties = PropertyUtil.getProperties(PROPERTIES_NAME);
        if (properties == null) {
            properties = new Properties();
        }
        if ((propertySource = new PropertySource(properties)).getProperty(SERVER_PORT) != null) {
            propertySource.setProperty(APPLICATION_PORT, propertySource.getProperty(SERVER_PORT));
        }
        list.add(propertySource);
        String env = defaultSource.getProperty(SPRING_ENV);
        if (StringUtil.isNullOrEmpty((String)env) && StringUtil.isNullOrEmpty((String)(env = defaultSource.getProperty(APPLICATION_ENV)))) {
            String string = env = StringUtil.isNullOrEmpty((String)propertySource.getProperty(SPRING_ENV)) ? propertySource.getProperty(APPLICATION_ENV) : propertySource.getProperty(SPRING_ENV);
        }
        if (!StringUtil.isNullOrEmpty((String)env)) {
            Properties envProperties = PropertyUtil.getProperties(String.format(PROPERTIES_ENV_NAME, env));
            if (envProperties == null) {
                envProperties = PropertyUtil.getProperties("config/" + String.format(PROPERTIES_ENV_NAME, env));
            }
            if (envProperties != null) {
                PropertySource envSource = new PropertySource(envProperties);
                list.add(envSource);
            }
        }
        return list;
    }
}

