/*
 * Decompiled with CFR 0.152.
 */
package retry;

import akka.actor.ActorSystem;
import javax.inject.Inject;
import retry.BackoffRetry;
import retry.BaseRetry;
import retry.FibonacciRetry;
import retry.FixedDelayRetry;
import retry.JitterRetry;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001\u0015\u0011QAU3uefT\u0011aA\u0001\u0006e\u0016$(/_\u0002\u0001'\t\u0001a\u0001\u0005\u0002\b\u00155\t\u0001BC\u0001\n\u0003\u0015\u00198-\u00197b\u0013\tY\u0001B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001b\u0001\u0011\t\u0011)A\u0005\u001d\u0005\u0011Qm\u0019\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#!\t!bY8oGV\u0014(/\u001a8u\u0013\t\u0019\u0002C\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"AQ\u0003\u0001B\u0001B\u0003%a#A\u0006bGR|'oU=ti\u0016l\u0007CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0015\t7\r^8s\u0015\u0005Y\u0012\u0001B1lW\u0006L!!\b\r\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0005\u001aC\u0005\u0005\u0002#\u00015\t!\u0001C\u0003\u000e=\u0001\u0007a\u0002C\u0003\u0016=\u0001\u0007a\u0003\u000b\u0002\u001fMA\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0007S:TWm\u0019;\u000b\u0003-\nQA[1wCbL!!\f\u0015\u0003\r%s'.Z2u\u0011\u0015y\u0003\u0001\"\u00011\u000399\u0018\u000e\u001e5GSb,G\rR3mCf,\"!M\u001c\u0015\u0007I\u0002U\tE\u0002#gUJ!\u0001\u000e\u0002\u0003\u0013\t\u000b7/\u001a*fiJL\bC\u0001\u001c8\u0019\u0001!Q\u0001\u000f\u0018C\u0002e\u0012\u0011\u0001V\t\u0003uu\u0002\"aB\u001e\n\u0005qB!a\u0002(pi\"Lgn\u001a\t\u0003\u000fyJ!a\u0010\u0005\u0003\u0007\u0005s\u0017\u0010C\u0003B]\u0001\u0007!)A\u0004sKR\u0014\u0018.Z:\u0011\u0005\u001d\u0019\u0015B\u0001#\t\u0005\rIe\u000e\u001e\u0005\u0006\r:\u0002\raR\u0001\u0006I\u0016d\u0017-\u001f\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015B\t\u0001\u0002Z;sCRLwN\\\u0005\u0003\u0019&\u0013aBR5oSR,G)\u001e:bi&|g\u000eC\u0003O\u0001\u0011\u0005q*\u0001\txSRD')Y2l_\u001a4G)\u001a7bsV\u0011\u0001k\u0015\u000b\u0005#R+f\u000bE\u0002#gI\u0003\"AN*\u0005\u000baj%\u0019A\u001d\t\u000b\u0005k\u0005\u0019\u0001\"\t\u000b\u0019k\u0005\u0019A$\t\u000b]k\u0005\u0019\u0001-\u0002\r\u0019\f7\r^8s!\t9\u0011,\u0003\u0002[\u0011\t1Ai\\;cY\u0016DQ\u0001\u0018\u0001\u0005\u0002u\u000bqb^5uQ*KG\u000f^3s\t\u0016d\u0017-_\u000b\u0003=\u0006$Ba\u00182dKB\u0019!e\r1\u0011\u0005Y\nG!\u0002\u001d\\\u0005\u0004I\u0004\"B!\\\u0001\u0004\u0011\u0005\"\u00023\\\u0001\u00049\u0015\u0001C7j]\u0012+G.Y=\t\u000b\u0019\\\u0006\u0019A$\u0002\u00115\f\u0007\u0010R3mCfDQ\u0001\u001b\u0001\u0005\u0002%\f!c^5uQ\u001aK'm\u001c8bG\u000eLG)\u001a7bsV\u0011!.\u001c\u000b\u0004W:|\u0007c\u0001\u00124YB\u0011a'\u001c\u0003\u0006q\u001d\u0014\r!\u000f\u0005\u0006\u0003\u001e\u0004\rA\u0011\u0005\u0006a\u001e\u0004\raR\u0001\nE\u0006\u001cX\rR3mCf<QA\u001d\u0002\t\u0002M\fQAU3uef\u0004\"A\t;\u0007\u000b\u0005\u0011\u0001\u0012A;\u0014\u0005Q4\u0001\"B\u0010u\t\u00039H#A:\t\u000b=\"H\u0011A=\u0016\u0005itH#B>\u0002\f\u00055A\u0003\u0002?\u0000\u0003\u0003\u00012AI\u001a~!\t1d\u0010B\u00039q\n\u0007\u0011\bC\u0003\u000eq\u0002\u000fa\u0002C\u0004\u0002\u0004a\u0004\u001d!!\u0002\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bcA\f\u0002\b%\u0019\u0011\u0011\u0002\r\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\b\"B!y\u0001\u0004\u0011\u0005\"\u0002$y\u0001\u00049\u0005B\u0002(u\t\u0003\t\t\"\u0006\u0003\u0002\u0014\u0005mA\u0003CA\u000b\u0003C\t\u0019#!\n\u0015\r\u0005]\u0011QDA\u0010!\u0011\u00113'!\u0007\u0011\u0007Y\nY\u0002\u0002\u00049\u0003\u001f\u0011\r!\u000f\u0005\u0007\u001b\u0005=\u00019\u0001\b\t\u0011\u0005\r\u0011q\u0002a\u0002\u0003\u000bAa!QA\b\u0001\u0004\u0011\u0005B\u0002$\u0002\u0010\u0001\u0007q\t\u0003\u0004X\u0003\u001f\u0001\r\u0001\u0017\u0005\u00079R$\t!!\u000b\u0016\t\u0005-\u00121\u0007\u000b\t\u0003[\tI$a\u000f\u0002>Q1\u0011qFA\u001b\u0003o\u0001BAI\u001a\u00022A\u0019a'a\r\u0005\ra\n9C1\u0001:\u0011\u0019i\u0011q\u0005a\u0002\u001d!A\u00111AA\u0014\u0001\b\t)\u0001\u0003\u0004B\u0003O\u0001\rA\u0011\u0005\u0007I\u0006\u001d\u0002\u0019A$\t\r\u0019\f9\u00031\u0001H\u0011\u0019AG\u000f\"\u0001\u0002BU!\u00111IA&)\u0019\t)%!\u0015\u0002TQ1\u0011qIA'\u0003\u001f\u0002BAI\u001a\u0002JA\u0019a'a\u0013\u0005\ra\nyD1\u0001:\u0011\u0019i\u0011q\ba\u0002\u001d!A\u00111AA \u0001\b\t)\u0001\u0003\u0004B\u0003\u007f\u0001\rA\u0011\u0005\u0007a\u0006}\u0002\u0019A$")
public class Retry {
    private final ExecutionContext ec;
    private final ActorSystem actorSystem;

    public <T> BaseRetry<T> withFixedDelay(int retries, FiniteDuration delay) {
        return new FixedDelayRetry(retries, delay, this.ec, this.actorSystem.scheduler());
    }

    public <T> BaseRetry<T> withBackoffDelay(int retries, FiniteDuration delay, double factor) {
        return new BackoffRetry(retries, delay, factor, this.ec, this.actorSystem.scheduler());
    }

    public <T> BaseRetry<T> withJitterDelay(int retries, FiniteDuration minDelay, FiniteDuration maxDelay) {
        return new JitterRetry(retries, minDelay, maxDelay, this.ec, this.actorSystem.scheduler());
    }

    public <T> BaseRetry<T> withFibonacciDelay(int retries, FiniteDuration baseDelay) {
        return new FibonacciRetry(retries, baseDelay, this.ec, this.actorSystem.scheduler());
    }

    @Inject
    public Retry(ExecutionContext ec, ActorSystem actorSystem) {
        this.ec = ec;
        this.actorSystem = actorSystem;
    }
}

