/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.maven.plugin;

import io.polaris.maven.plugin.DuplicateFile;
import io.polaris.maven.plugin.PropertiesKit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="transform", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class PropertiesTransformMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    public String encoding;
    @Parameter
    public String[] includes;
    @Parameter
    public String[] excludes;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    public File outputDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    public File testOutputDirectory;
    @Parameter
    public DuplicateFile[] duplicateFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.includes == null) {
            this.includes = new String[]{"**/*.properties"};
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        if (this.encoding == null || this.encoding.isEmpty()) {
            this.encoding = Charset.defaultCharset().displayName();
            this.getLog().warn((CharSequence)("Using platform encoding (" + this.encoding + " actually) to convert resources!"));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Includes: " + Arrays.asList(this.includes)));
            this.getLog().debug((CharSequence)("Excludes: " + Arrays.asList(this.excludes)));
        }
        String incl = PropertiesKit.join(",", this.includes);
        String excl = PropertiesKit.join(",", this.excludes);
        this.transform(this.outputDirectory, incl, excl);
        this.transform(this.testOutputDirectory, incl, excl);
        this.duplicate(this.outputDirectory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void transform(File dir, String incl, String excl) throws MojoExecutionException {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        try {
            for (File file : FileUtils.getFiles((File)dir, (String)incl, (String)excl)) {
                try {
                    this.getLog().info((CharSequence)("Converting file: " + file));
                    PropertiesKit.nativeToAscii(this.getLog(), file, this.encoding);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to convert file:" + file.getAbsolutePath(), (Exception)e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to convert files: " + dir.getAbsoluteFile());
        }
    }

    private void duplicate(File dir) throws MojoExecutionException {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        if (this.duplicateFiles == null || this.duplicateFiles.length == 0) {
            return;
        }
        for (DuplicateFile conf : this.duplicateFiles) {
            if (conf.src == null || conf.src.isEmpty()) {
                this.getLog().warn((CharSequence)"duplicate src is required!");
                continue;
            }
            if (conf.dest == null || conf.dest.isEmpty()) {
                this.getLog().warn((CharSequence)"duplicate src is required!");
                continue;
            }
            File src = new File(dir, conf.src);
            File dest = new File(dir, conf.dest);
            if (src.exists() && dest.exists()) continue;
            if (src.exists()) {
                try {
                    this.getLog().info((CharSequence)("Duplicate file: " + src + " to " + dest));
                    PropertiesKit.copy(src, dest);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to duplicate file: " + src + " to " + dest, (Exception)e);
                }
            }
            if (!dest.exists()) continue;
            try {
                this.getLog().info((CharSequence)("Duplicate file: " + dest + " to " + src));
                PropertiesKit.copy(dest, src);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to duplicate file: " + dest + " to " + src, (Exception)e);
            }
        }
    }
}

