/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.maven.plugin;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringJoiner;
import org.apache.maven.plugin.logging.Log;

public class PropertiesKit {
    public static String nativeToAscii(Log log, String string) {
        if (string == null) {
            return null;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((CharSequence)("native2ascii string: " + string));
        }
        return PropertiesKit.nativeToAscii(string);
    }

    public static void nativeToAscii(Log log, File file, String encoding) throws IOException {
        if (log != null && log.isDebugEnabled()) {
            log.debug((CharSequence)("native2ascii file: " + file.getAbsoluteFile()));
        }
        String lineSep = "\n";
        try (FileInputStream in = new FileInputStream(file);){
            byte[] bytes = new byte[1024];
            int len = 0;
            block36: while ((len = in.read(bytes)) != -1) {
                for (int i = 0; i < len; ++i) {
                    byte b = bytes[i];
                    if (b == 13) {
                        int b1;
                        if (i < len - 1) {
                            b1 = bytes[i + 1];
                            if (b1 == 10) {
                                lineSep = "\r\n";
                                continue block36;
                            }
                            lineSep = "\r";
                            continue block36;
                        }
                        b1 = in.read();
                        if (b1 == 10) {
                            lineSep = "\r\n";
                            continue block36;
                        }
                        lineSep = "\r";
                        continue block36;
                    }
                    if (b != 10) continue;
                    lineSep = "\n";
                    continue block36;
                }
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(file);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, encoding));
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding));){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    bw.write(lineSep);
                    continue;
                }
                if (line.charAt(0) == '#') {
                    if (line.length() > 1) {
                        if (line.charAt(1) != ' ') {
                            bw.write(35);
                            bw.write(32);
                            bw.write(line.substring(1));
                        } else {
                            bw.write(line);
                        }
                    } else {
                        bw.write(35);
                    }
                    bw.write(lineSep);
                    continue;
                }
                bw.write(PropertiesKit.nativeToAscii(line));
                bw.write(lineSep);
            }
            bw.flush();
        }
        byte[] bytes = out.toByteArray();
        PropertiesKit.writeBytes(file, bytes);
    }

    public static String nativeToAscii(String s) {
        StringBuilder sb = new StringBuilder();
        char[] chs = s.toCharArray();
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] > '\u0000' && chs[i] < '\u007f' && chs[i] != '\\') {
                sb.append(chs[i]);
                continue;
            }
            String str = Integer.toString(chs[i], 16);
            sb.append("\\u").append("0000", 0, 4 - str.length()).append(str);
        }
        return sb.toString();
    }

    public static void mkdirParent(File file) {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void writeBytes(File file, byte[] bytes) throws IOException {
        PropertiesKit.mkdirParent(file);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            out.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File src, File dest) throws IOException {
        int n;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            PropertiesKit.mkdirParent(dest);
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            int i = PropertiesKit.copy(in, out);
            out.flush();
            n = i;
        }
        catch (Throwable throwable) {
            PropertiesKit.close(out);
            PropertiesKit.close(in);
            throw throwable;
        }
        PropertiesKit.close(out);
        PropertiesKit.close(in);
        return n;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return PropertiesKit.copy(input, output, 4096);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int n;
        byte[] buffer = new byte[bufferSize];
        int count = 0;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += n;
        }
        output.flush();
        return count;
    }

    public static void close(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static String join(CharSequence delimiter, CharSequence ... arr) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence s : arr) {
            if (s == null || s.length() == 0) continue;
            joiner.add(s);
        }
        return joiner.toString();
    }
}

