package cn.pengh.util;

import cn.pengh.math.JVMRandom;

import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;

/**
 * @author penghcn
 * @created 2015年7月16日下午3:19:59
 */
public class RandomUtil {
    public static final Random JVM_RANDOM = new JVMRandom();
    private static final byte[] CHAR_STR = {
            (byte) 'a', (byte) 'b', (byte) 'c', (byte) 'd',
            (byte) 'e', (byte) 'f', (byte) 'g', (byte) 'h', (byte) 'i', (byte) 'j', (byte) 'k', (byte) 'l',
            (byte) 'm', (byte) 'n', (byte) 'o', (byte) 'p', (byte) 'q', (byte) 'r', (byte) 's', (byte) 't',
            (byte) 'u', (byte) 'v', (byte) 'w', (byte) 'x', (byte) 'y', (byte) 'z'
    };
    private static final byte[] CHAR_STR_UP = {
            (byte) 'A', (byte) 'B', (byte) 'C', (byte) 'D', (byte) 'E', (byte) 'F',
            (byte) 'G', (byte) 'H', (byte) 'I', (byte) 'J', (byte) 'K', (byte) 'L', (byte) 'M', (byte) 'N',
            (byte) 'O', (byte) 'P', (byte) 'Q', (byte) 'R', (byte) 'S', (byte) 'T', (byte) 'U', (byte) 'V',
            (byte) 'W', (byte) 'X', (byte) 'Y', (byte) 'Z'
    };

    private static final byte[] NUM_STR = {
            (byte) '0', (byte) '1', (byte) '2', (byte) '3', (byte) '4', (byte) '5', (byte) '6', (byte) '7',
            (byte) '8', (byte) '9'
    };

    private static final byte[] UNRESERVED_STR = {
            (byte) '-', (byte) '.', (byte) '_', (byte) '~'
    };

    private static final byte[] UNRESERVED2_STR = {
            (byte) '!', (byte) '@', (byte) '#', (byte) '$', (byte) '%', (byte) '^', (byte) '&', (byte) '*',
            (byte) '+', (byte) '=', (byte) '/', (byte) '|', (byte) ',', (byte) ':', (byte) ';'
    };


    private static final byte[] CHAR_NUM_STR = ArrayUtil.concatAll(CHAR_STR, NUM_STR);
    private static final byte[] CHAR_NUM_STR_UP = ArrayUtil.concatAll(CHAR_STR, CHAR_STR_UP, NUM_STR);
    private static final byte[] CHAR_NUM_UNRESERVED_STR_UP = ArrayUtil.concatAll(CHAR_STR, CHAR_STR_UP, NUM_STR, UNRESERVED_STR);
    private static final byte[] CHAR_NUM_UNRESERVED2_STR_UP = ArrayUtil.concatAll(CHAR_STR, CHAR_STR_UP, NUM_STR, UNRESERVED_STR, UNRESERVED2_STR);

    //生成指定长度位的随机str
    /*private static String generator(int length, char[] str) {
        if (length == 0)
            return "";
        final int maxNum = str.length;
        int i;
        int count = 0;
        StringBuffer pwd = new StringBuffer();
        while (count < length) {
            i = nextInt(maxNum);
            if (i >= 0 && i < str.length) {
                pwd.append(str[i]);
                count++;
            }
        }
        return pwd.toString();
    }*/

    private static String generator(int length, byte[] arr) {
        if (length == 0) {
            return "";
        }
        final int maxNum = arr.length;
        ByteBuffer buffer = ByteBuffer.allocate(length);
        for (int i = 0; i < length; i++) {
            buffer.put(arr[nextInt(maxNum)]);
        }

        return ArrayUtil.toString(buffer);
    }

    //生成指定长度位的字符(大小写)或者数字、保留字符-_.~
    public static String genCharNumUnreservedUp(int length) {
        return generator(length, CHAR_NUM_UNRESERVED_STR_UP);
    }

    //生成指定长度位的字符(大小写)或者数字、各种保留字符，适用密码、乱码等
    public static String genCharNumUnreserved2Up(int length) {
        return generator(length, CHAR_NUM_UNRESERVED2_STR_UP);
    }

    //生成指定长度位的字符(大小写)或者数字
    public static String genCharNumUp(int length) {
        return generator(length, CHAR_NUM_STR_UP);
    }

    //生成指定长度位的字符或者数字
    public static String genCharNum(int length) {
        return generator(length, CHAR_NUM_STR);
    }

    //生成指定长度位的字符
    public static String genChar(int length) {
        return generator(length, CHAR_STR);
    }

    //生成指定长度位的随机数
    public static String genNum(int length) {
        return generator(length, NUM_STR);
    }


    public static int nextIntNoZero() {
        return 1 + nextInt();
    }

    public static int nextIntNoZero(int n) {
        return 1 + nextInt(n);
    }


    public static int nextInt() {
        return nextInt(JVM_RANDOM);
    }

    public static int nextInt(Random random) {
        return random.nextInt();
    }

    public static int nextInt(int n) {
        return nextInt(JVM_RANDOM, n);
    }


    public static int nextInt(Random random, int n) {
        return random.nextInt(n);
    }

    public static long nextLong() {
        return nextLong(JVM_RANDOM);
    }

    public static long nextLong(Random random) {
        return random.nextLong();
    }

    public static boolean nextBoolean() {
        return nextBoolean(JVM_RANDOM);
    }

    public static boolean nextBoolean(Random random) {
        return random.nextBoolean();
    }

    public static float nextFloat() {
        return nextFloat(JVM_RANDOM);
    }

    public static float nextFloat(Random random) {
        return random.nextFloat();
    }

    public static double nextDouble() {
        return nextDouble(JVM_RANDOM);
    }

    public static double nextDouble(Random random) {
        return random.nextDouble();
    }

    //32位随机字符串
    public static String getNonceStr() {
        return genCharNumUp(32);
    }

    //43位随机字符串
    public static String getVerifierStr() {
        return genCharNumUnreservedUp(43);
    }

    //54位随机字符串
    public static String getStr54() {
        return genCharNumUnreserved2Up(54);
    }

    private static final DateTimeFormatter DT_TIME_FORMAT = DateTimeFormatter.ofPattern("yyMM-ddHH-mmss");
    private static final DateTimeFormatter DT_TIME_FORMAT2 = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");

    //19位随机字符串，中间含间隔号-
    public static String getSerial() {
        return LocalDateTime.now().format(DT_TIME_FORMAT) + "-" + genNum(4);
    }

    //19位随机字符串，纯数字
    public static String getSerialWithoutSplit() {
        return LocalDateTime.now().format(DT_TIME_FORMAT2) + genNum(4);
    }

}
