package cn.pengh.util;

import cn.pengh.exception.CustomException;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * @author Created by pengh
 * @datetime 2023/6/12 11:26
 */
public class MathUtil {
    private static final byte H100 = 100;
    private static final byte B_16_AND_3 = 16 + 3;
    private static final int I_65536 = 65536;
    private static final int I_52429 = 52429;
    public static final byte[] DIGIT_TENS = {
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
            4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
            5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
            6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
            7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
            8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
            9, 9, 9, 9, 9, 9, 9, 9, 9, 9
    };

    public static final byte[] DIGIT_ONES = {
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9
    };

    private static final byte[] C_4 = {4};
    private static final byte[] C_7 = {7};
    private static final byte[] C_4_7 = {4, 7};

    private static final byte[] H_BIT_0 = {
            1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 0, 0, 0, 0, 0, 0, 0, 0, 0
    };
    private static final byte[] H_BIT_4 = {
            0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 0, 0, 0
    };
    private static final byte[] H_BIT_7 = {
            0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 1, 0, 0
    };
    private static final byte[] H_BIT_4_7 = {
            0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
            0, 0, 0, 0, 1, 0, 0, 1, 0, 0
    };

    /**
     * 某正整数是否包含4、7
     *
     * @param num
     * @return
     */
    public static boolean contains47(long num) {
        //return contains(num, C_4_7);
        return contains_(num, H_BIT_4_7);
    }

    // 某正整数是否包含4
    public static boolean contains4(long num) {
        //return contains(num, C_4);
        return contains_(num, H_BIT_4);
    }

    public static boolean contains7(long num) {
        //return contains(num, C_7);
        return contains_(num, H_BIT_7);
    }

    public static boolean contains0(long num) {
        return contains_(num, H_BIT_0);
    }

    private static boolean contains(long num, byte[] arr, int len) {
        for (int i = 0; i < len; i++) {
            if (num == arr[i]) {
                return true;
            }
        }
        return false;
    }

    /**
     * 参考 java.lang.Long getChars()
     *
     * @param i
     * @param arr 含某些数字的集合，如含4则{4}，同时含4和7则{4,7}
     * @return
     */
    public static boolean contains(long i, byte[] arr) {
        /*if (i <= 0) {
            return false;
        }
        int len = arr.length;
        while (i > 0) {
            if (contains(i % 10, arr, len)) {
                return true;
            }
            i = i / 10;
        }
        return false;*/
        //Log.getSlf4jLogger().debug("{}", i);
        if (i < 0) {
            return false;
        }
        long q;
        int r, len = arr.length;

        while (i > Integer.MAX_VALUE) {
            q = i / H100;
            // really: r = i - (q * 100);
            r = (int) (i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            //Log.getSlf4jLogger().debug("{},{}", DigitOnes[r], r);
            //Log.getSlf4jLogger().debug("{},{}", DigitTens[r], r);
            if (contains(DIGIT_ONES[r], arr, len) || contains(DIGIT_TENS[r], arr, len)) {
                return true;
            }
        }

        int q2;
        int i2 = (int) i;
        while (i2 >= I_65536) {
            q2 = i2 / H100;
            // really: r = i - (q * 100);
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            //Log.getSlf4jLogger().debug("{},{}", DigitOnes[r], r);
            //Log.getSlf4jLogger().debug("{},{}", DigitTens[r], r);

            if (contains(DIGIT_ONES[r], arr, len) || contains(DIGIT_TENS[r], arr, len)) {
                return true;
            }
        }

        for (; ; ) {
            q2 = (i2 * I_52429) >>> B_16_AND_3;
            r = i2 - ((q2 << 3) + (q2 << 1));  // r = i2-(q2*10) ...
            i2 = q2;

            //Log.getSlf4jLogger().debug("{},{}", r, r);
            if (contains(r, arr, len)) {
                return true;
            }
            if (i2 == 0) {
                break;
            }
        }
        return false;
    }

    /**
     * 参考 java.lang.Long getChars()
     * 先本地定义真假位图，以空间换时间
     *
     * @param i
     * @param arr 含某数字的一百以内的真假位图，是则为1，如含4的H_BIT_4
     * @return
     */
    private static boolean contains_(long i, byte[] arr) {
        //Log.getSlf4jLogger().debug("{}", i);
        if (i < 0) {
            return false;
        }
        long q;
        int r;

        while (i > Integer.MAX_VALUE) {
            q = i / H100;
            // really: r = i - (q * 100);
            // 100 = 64 + 32 + 4
            r = (int) (i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            //Log.getSlf4jLogger().debug("{}", r);
            if (arr[r] == 1) {
                return true;
            }
        }

        int q2;
        int i2 = (int) i;
        while (i2 >= I_65536) {
            q2 = i2 / H100;
            // really: r = i - (q * 100);
            // 100 = 64 + 32 + 4
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            //Log.getSlf4jLogger().debug("{}", r);
            if (arr[r] == 1) {
                return true;
            }
        }

        /**
         *
         * 因为2<<(16+3)=2<<19=524288,
         * (i * 52429)>>>(16+3) = i*52429/524288=
         * 52429.0/524288=0.1000003814697......
         * 6位的精度已经足够多了，所以就是i*0.1
         *
         * 2^10=1024, 103/1024=0.1005859375
         * 2^11=2048, 205/2048=0.10009765625
         * 2^12=4096, 410/4096=0.10009765625
         * 2^13=8192, 820/8192=0.10009765625
         * 2^14=16384, 1639/16384=0.10003662109375
         * 2^15=32768, 3277/32768=0.100006103515625
         * 2^16=65536, 6554/65536=0.100006103515625
         * 2^17=131072, 13108/131072=0.100006103515625
         * 2^18=262144, 26215/262144=0.10000228881835938
         * 2^19=524288, 52429/524288=0.10000038146972656
         *
         * 选19是在不超出整形范围内，精度最高的。
         *
         * ((Integer.MAX_VALUE + 1L) * 2L -1) / 52429 == 81919， 选65536
         */

        // i < 2^16=65536
        for (; ; ) {
            q2 = (i2 * I_52429) >>> B_16_AND_3;
            r = i2 - ((q2 << 3) + (q2 << 1));  // r = i2-(q2*10) ...
            i2 = q2;

            //Log.getSlf4jLogger().debug("{},{}", r, r);
            if (arr[r] == 1) {
                return true;
            }
            if (i2 == 0) {
                break;
            }
        }
        return false;
    }

    /**
     * List<OrderDto> list = orders.stream().filter(distinctByKey(OrderDto::getOrderNo)).collect(Collectors.toList());
     * @param keyExtractor
     * @return
     * @param <T>
     */
    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        Set<Object> seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private static final char[] HEX_CODE = "0123456789abcdef".toCharArray();
    private static final char HEX_F = 0xf;
    public static String byteToHex(byte[] arr) {
        StringBuilder ret = new StringBuilder(arr.length * 2);
        for (byte b : arr) {
            ret.append(HEX_CODE[(b >> 4) & HEX_F]);
            ret.append(HEX_CODE[(b & HEX_F)]);
        }
        return ret.toString();
    }
    public static byte[] hexToByte(String s) {
        final int len = s.length();

        if (len % 2 != 0) {
            throw CustomException.create("二进制字符长度需是偶数: " + s);
        }

        byte[] out = new byte[len / 2];

        for (int i = 0; i < len; i += 2) {
            int h = hexToByte(s.charAt(i));
            int l = hexToByte(s.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw CustomException.create("不合法字符: " + s);
            }
            out[i / 2] = (byte) (h * 16 + l);
        }
        return out;
    }

    private static int hexToByte(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - '0';
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 'A' + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 'a' + 10;
        }
        return -1;
    }
}
