package cn.pengh.util;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 数组操作
 * org.apache.commons.lang3.ArrayUtils
 *
 * @author penghcn
 * @created 2016年3月23日上午9:44:26
 */
public class ArrayUtil {
    //ArrayUtils.addAll(first, second);
    @SuppressWarnings("unchecked")
    public static <T> T[] concatAll(T[] first, T[]... rests) {
        if (rests == null)
            return first;
        if (first == null) {
            first = (T[]) Array.newInstance(rests[0].getClass().getComponentType(), rests.length);
        }
        int offset = first.length, totalSize = offset;
        for (T[] array : rests) {
            totalSize += array.length;
        }
        T[] result = Arrays.copyOf(first, totalSize);
        for (T[] array : rests) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static char[] concatAll(char[] first, char[]... rests) {
        if (rests == null)
            return first;
        if (first == null) {
            first = (char[]) Array.newInstance(rests[0].getClass().getComponentType(), rests.length);
        }
        int offset = first.length, totalSize = offset;
        for (char[] array : rests) {
            totalSize += array.length;
        }
        char[] result = Arrays.copyOf(first, totalSize);
        for (char[] array : rests) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static byte[] concatAll(byte[] first, byte[]... rests) {
        if (rests == null)
            return first;
        if (first == null) {
            first = (byte[]) Array.newInstance(rests[0].getClass().getComponentType(), rests.length);
        }
        int offset = first.length, totalSize = offset;
        for (byte[] array : rests) {
            totalSize += array.length;
        }
        byte[] result = Arrays.copyOf(first, totalSize);
        for (byte[] array : rests) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        int i = 0, j = array.length - 1;
        byte tmp;
        while (j > i) {
            tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            j--;
            i++;
        }
    }

    public static String toString(ByteBuffer buffer) {
        return toString(buffer, false);
    }

    public static String toReverseString(ByteBuffer buffer) {
        return toString(buffer, true);
    }

    // https://zhuanlan.zhihu.com/p/56876443
    public static String toString(ByteBuffer buffer, boolean isReverse) {
        /*byte[] bytes = new byte[buffer.position()]; //此为写入模式，position为实际长度
        buffer.rewind(); //还是写模式，重置position为0
        buffer.get(bytes);*/

        //切换读模式
        buffer.flip();
        byte[] bytes = new byte[buffer.limit()]; //读模式，limit为实际长度，或使用buffer.remaining()
        buffer.get(bytes);

        if (isReverse) {
            reverse(bytes);
        }
        return new String(bytes);
    }



    public static int[] sortInt(List<Integer> list) {
        return list.stream().sorted().mapToInt(Integer::valueOf).toArray();
    }
    public static int[] sortInt(int... arr) {
        Arrays.sort(arr);
        return arr;
    }

    public static short[] sortShort(short... arr) {
        Arrays.sort(arr);
        return arr;
    }
    public static short[] sortShort(List<Short> list) {
        int n = list.size();
        Collections.sort(list); // 顺序排列
        short[] arr = new short[n];
        for (int i = 0; i < n; i++) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static byte[] sortByte(byte... arr) {
        Arrays.sort(arr);
        return arr;
    }
    public static byte[] sortByte(List<Byte> list) {
        int n = list.size();
        Collections.sort(list); // 顺序排列
        byte[] arr = new byte[n];
        for (int i = 0; i < n; i++) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static boolean contains(byte[] sortedArr, byte e) {
        return Arrays.binarySearch(sortedArr, e) > -1;
    }

    public static boolean contains(short[] sortedArr, short e) {
        return Arrays.binarySearch(sortedArr, e) > -1;
    }
    public static boolean contains(int[] sortedArr, int e) {
        return Arrays.binarySearch(sortedArr, e) > -1;
    }

    public static <T> boolean contains(T[] sortedArr, T e) {
        return Arrays.binarySearch(sortedArr, e) > -1;
    }
}
