package cn.pengh.io.json;

import cn.pengh.util.StringUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import java.io.IOException;
import java.util.Set;

/**
 * @author Created by pengh
 * @datetime 2023/6/20 16:13
 */
public class MaskJacksonSerializer extends StdSerializer<MaskDataConfig> {
    public MaskJacksonSerializer(Class<MaskDataConfig> clazz) {
        super(clazz);
    }

    @Override
    public void serialize(MaskDataConfig config, JsonGenerator gen, SerializerProvider provider) throws IOException {
        //Log.getSlf4jLogger().debug("{}:{}", config.getData(), config.getMaskFields());
        JsonNode objectNode = convertValue(config.getData(), gen.getCodec());
        findFieldsForName(objectNode, config.getMaskFields(), config.getType(), null, objectNode);
        gen.writeObject(objectNode);
    }

    private JsonNode convertValue(Object node, ObjectCodec objectCodec) throws JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper) objectCodec;
        if (node instanceof String) {
            //Log.getSlf4jLogger().debug("{}", node);
            return mapper.readTree(node.toString());
        }
        return mapper.convertValue(node, JsonNode.class);
    }

    private void findFieldsForName(JsonNode node, Set<String> maskFields, byte maskType, String field, JsonNode parent) {
        if (node.isArray()) {
            if (maskFields.contains(field)) {
                this.apply(node.toString(), field, (ObjectNode) parent, maskType);
            } else {
                node.elements().forEachRemaining((element) -> this.findFieldsForName(element, maskFields, maskType, null, node));
            }
        } else if (node.isObject()) {
            if (maskFields.contains(field)) {
                this.apply(node.toString(), field, (ObjectNode) parent, maskType);
            } else {
                node.fields().forEachRemaining((f) -> this.findFieldsForName(f.getValue(), maskFields, maskType, f.getKey(), node));
            }
        } /*else if (node.isTextual() && maskFields.contains(field)) {
            this.apply(node.textValue(), field, (ObjectNode) parent, maskType);
        } */ else if (maskFields.contains(field)) {
            this.apply(node.asText(), field, (ObjectNode) parent, maskType);
        }

    }

    private void apply(String value, String field, ObjectNode node, byte maskType) {
        //Log.getSlf4jLogger().debug("{}:{} -> {}", field, value, maskType);
        if (maskType == 0) {
            node.put(field, "******");
        } else if (maskType == -1) {
            // ignore value
            value = null;
            node.put(field, value);
        } else if (maskType == 4) {
            node.put(field, StringUtil.addMaskStar(value, 0, 4));
        } else if (maskType == 34) {
            node.put(field, StringUtil.addMaskStar(value, 3, 4));
        } else {
            node.put(field, value);
        }
    }
}