package cn.pengh.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.charset.Charset;

import cn.pengh.exception.SocketException;
import cn.pengh.library.Log;
import cn.pengh.util.StringUtil;

/** 与网关tcpip通信 */
public class SocketClient {
	private String hostIP;
	private int hostPort;
	private int timeout = 50 * 1000;
	private String charset = Charset.defaultCharset().name();
	
	public SocketClient() {
	}

	public SocketClient(String ip, int port) {
		this.hostIP = ip;
		this.hostPort = port;
	}

	public SocketClient(String ip, int port, String charset) {
		this.hostIP = ip;
		this.hostPort = port;
		this.charset = charset;
	}

	public SocketClient(String ip, int port, String charset, int timeout) {
		this.hostIP = ip;
		this.hostPort = port;
		this.timeout = timeout;
		this.charset = charset;
	}

	/**
	 * 发送至网关以及账务系统(报文加四位长度位，返回报文去除四位长度位返回结果) <br/>
	 * 发送字节报文, 通信的报文增加4位报文长度字节,结果截取了四位报文长度,只为报文内容<br/>
	 * 即发送的内容和返回的内容不含报文长度字节<br/>
	 * charset:通信使用的编码
	 * */
	public String send(byte[] bytes) throws SocketException {
		try {
			String sendStr = StringUtil.leftPad(bytes.length + "", 4, "0") + new String(bytes, charset);
			return send(sendStr);
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}
	public String sendByNoPad(byte[] bytes) throws SocketException {
		try {
			return send(new String(bytes, charset),true);
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}
	public String send(String sendStr) throws SocketException {
		return send(sendStr, false);
	}
	public String send(String sendStr,boolean isBackLength) throws SocketException {
		byte[] sendBytes = null;
		try {
			Log.debug("发送报文:" + sendStr);
			sendBytes = sendStr.getBytes(charset);
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
		}
		OutputStream outputStream;
		InputStream in;
		Socket socket = null;
		try {
			Log.debug("连接[IP=" + hostIP + "，PORT=" + hostPort + "，TIMEOUT=" + timeout + "]");
			socket = new Socket(this.hostIP, this.hostPort);
			socket.setSoTimeout(timeout);
			outputStream = socket.getOutputStream();
			in = socket.getInputStream();
			Log.debug("连接成功[IP=" + hostIP + "，PORT=" + hostPort + "，TIMEOUT=" + timeout + "]");
			outputStream.write(sendBytes);
			outputStream.flush();			
		} catch (Exception e) {
			Log.error("发送数据" + e.getMessage());
			e.printStackTrace();
			throw new SocketException(SocketException.ERROR_CODE_SOCKET_TIMEOUT, SocketException.ERROR_MSG_SOCKET_TIMEOUT);
		}
		try {
			byte[] byteBuffer = new byte[4];
			in.read(byteBuffer);
			Log.debug("接收应答，数据包长度域" + new String(byteBuffer, charset));
			int packLen = Integer.parseInt(new String(byteBuffer, charset));
			int off = 0;
			byte[] buff = new byte[packLen];
			while (off < packLen) {
				int len = in.read(buff, off, packLen - off);
				if (len == -1) {
					break;
				}
				off = off + len;
			}
			byte[] result = buff;
			if (isBackLength) {
				result = new byte[4+packLen];
				System.arraycopy(byteBuffer, 0, result, 0, 4);
				System.arraycopy(buff, 0, result, 4, packLen);
			}

			String ret = new String(result, charset);			
			Log.debug("接收应答数据:" + ret);
			return ret;
		} catch (Exception e) {
			Log.error("接收数据" + e.getMessage());
			e.printStackTrace();
			throw new SocketException(SocketException.ERROR_CODE_SOCKET_TIMEOUT, SocketException.ERROR_MSG_SOCKET_TIMEOUT);
		} finally {
			try {
				if (in != null)
					in.close();
				if (outputStream != null)
					outputStream.close();

				if (socket != null)
					socket.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	

}
