package cn.pengh.helper;

import cn.pengh.library.ConfigReaderHolder;
import cn.pengh.util.StringUtil;
import com.alibaba.fastjson.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

public class StateDescHelper {
	@SuppressWarnings("unchecked")
	public static String getStateDesc4Option(JSONObject jo, String keyValue, String exceptKey){
		Set<Map.Entry<String,Object>> set = jo.entrySet();
		StringBuilder sb=new StringBuilder();
		String defaultValue = (String) jo.get(keyValue);
		List<String>exceptKeys=StringUtil.getListByExceptKey(exceptKey);
		if(defaultValue!=null)
			sb.append("<option value='"+keyValue+"' selected>"+defaultValue+"</option>");
		for (Entry<String, Object> entry : set) {
			String key = entry.getKey();
			String desc= entry.getValue() == null ? "" : entry.getValue().toString();
			if(exceptKeys.contains(key))
				continue;
			if(defaultValue==null||!defaultValue.equals(desc))
				sb.append("<option value='"+key+"' >"+desc+"</option>");	
		}
		return sb.toString();
	}
	
	public static String getStateDesc4Option(JSONObject jo,String keyValue){
		return getStateDesc4Option(jo, keyValue, "");
	}
	
	public static String getStateDesc4Option(String objectName,String keyValue){
		return getStateDesc4Option("desc", objectName, keyValue);
	}
	
	public static String getStateDesc4Option(String descPropertiesFileName,String objectName,String keyValue){
		String descs = ConfigReaderHolder.getInstance().getConfig(descPropertiesFileName, objectName).trim();
		JSONObject jo = JSONObject.parseObject(descs);
		return getStateDesc4Option(jo, keyValue, "");
	}


}
