package cn.pengh.helper;

import cn.pengh.library.JavaMethodBuilder;
import cn.pengh.library.Log;
import cn.pengh.util.FileUtil;
import cn.pengh.util.StringUtil;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

/**
 * @author Created by pengh
 * @datetime 2017/5/11 10:27
 */
public class JavaMethodBuilderHelper {
    private static String TMP_FILE = System.getProperty("java.io.tmpdir") + "/JavaMethodBuilderHelper.tmp.file";

    public static void gen(String clazzName, String filePath) {
        String s = JavaMethodBuilder.createDefault()
                .setClazzName(clazzName)
                .setConstruct(true)
                .setReturnThis(true)
                .setGet(true)
                .build()
                .parseFile(new File(filePath));
        System.out.printf(s);
    }

    public static void gen(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        for (Field f : clazz.getDeclaredFields()) {
            if (f.isSynthetic() || f.isEnumConstant())
                continue;
            if (Modifier.isStatic(f.getModifiers()))
                continue;

            sb.append("private ")
                    .append(getSimpleName(f.getGenericType().getTypeName()))
                    .append(" ")
                    .append(ClazzHelper.getSimpleLastName(f.getName()))
                    .append(";")
                    .append(System.getProperty("line.separator"));
        }

        //Log.debug(sb.toString());
        FileUtil.WriteContentsToFile(TMP_FILE, sb.toString());

        gen(ClazzHelper.getSimpleLastName(clazz.getName()), TMP_FILE);
    }

    //java.util.Map<java.lang.String, cn.pengh.mvc.simple.wx.req.WxTmplMsgData> data
    private static String getSimpleName(String str) {
        return str.replaceAll("([\\w_\\d]+\\.)?", "").replaceAll(", ", ",").replaceAll("\\$", "\\.");
    }

    public static void main(String[] args) {
        String s = "java.util.Map<java._lang._String, cn.pengh.mvc123.simple.wx.req.WxTmplMsgData$String> data";
        Log.error(getSimpleName(s));

        //gen(RestfulResponse.class);
    }

    public static void genInsertSql(Class<?> clazz) {
        gen2(clazz);
    }

    /*

CREATE TABLE t_month_wage(
    id                             INTEGER GENERATED ALWAYS AS IDENTITY (START WITH 80000000 INCREMENT BY 1),--id
    wage_month                     INTEGER         NOT NULL WITH DEFAULT 0,--工资月份
    user_no                        CHAR(10)        NOT NULL WITH DEFAULT,--对应职工工号
    state                          SMALLINT        NOT NULL WITH DEFAULT 0,-- 0待处理 1已确认(最终)
    wage_level                     CHAR(5)         NOT NULL WITH DEFAULT,--工资岗级
    pre_wage_level                 VARCHAR(60)     NOT NULL WITH DEFAULT,--发生调薪，调整前工资岗级,基本工分系数,工分单价 FU8,40,18.00
    wage_model                     CHAR(2)         NOT NULL WITH DEFAULT,--工资计算类型 1薪资套一 2薪资套二
    account_bank                   VARCHAR(60)     NOT NULL WITH DEFAULT,--工资卡银行
    account_no                     VARCHAR(60)     NOT NULL WITH DEFAULT,--工资卡账号
    level_point                    DECIMAL(8,0)    NOT NULL WITH DEFAULT,--岗级工分
    level_point_total              DECIMAL(12,2)   NOT NULL WITH DEFAULT,--累计工分
    tax_curr_total_wage            DECIMAL(12,2)   NOT NULL WITH DEFAULT,--本期累计已缴纳个税 = 历史累计已缴纳个税 + 本期个税
    remarks                        VARCHAR(2048)   NOT NULL WITH DEFAULT,--备注
    rec_upd_usr                    CHAR(32)        NOT NULL WITH DEFAULT  , -- 最近操作用户登录id
    upd_ts                         TIMESTAMP       NOT NULL WITH DEFAULT  , --最近更新时间
    crt_ts                         TIMESTAMP       NOT NULL WITH DEFAULT  , --最近更新时间
    PRIMARY KEY(id)
) ;
     */
    public static void genCreateTblMysql(Class<?> clazz) {
        genCreateTbl(clazz, false);
    }

    public static void genCreateTblDb2(Class<?> clazz) {
        genCreateTbl(clazz, true);
    }

    private static void genCreateTbl(Class<?> clazz, boolean isDb2) {
        StringBuilder sb = new StringBuilder();
        sb.append("create table <tbl> (").append(System.getProperty("line.separator"));

        for (Field f : clazz.getDeclaredFields()) {
            if (f.isSynthetic() || f.isEnumConstant()) {
                continue;
            }
            if (Modifier.isStatic(f.getModifiers())) {
                continue;
            }

            String filedNm = StringUtil.toUnderlineCase(ClazzHelper.getSimpleLastName(f.getName()));
            String[] arr = getType(filedNm, getSimpleName(f.getGenericType().getTypeName()), isDb2);
            if (arr == null) {
                continue;
            }
            sb.append(filedNm).append(" ")
                    .append(arr[0])
                    .append(filedNm.equals("id") ? "" : " NOT NULL " + (isDb2 ? "WITH " : "") + "DEFAULT ")
                    .append(arr[1]).append(System.getProperty("line.separator"));

        }
        sb.append(isDb2 ? "PRIMARY KEY(id)" : "PRIMARY KEY (id) COMMENT '' ").append(System.getProperty("line.separator"));
        sb.append(")").append(isDb2 ? "" : " ENGINE=InnoDB DEFAULT CHARSET=utf8").append(";");

        Log.debug(sb);
    }

    private static String[] getType(String filedNm, String filedType, boolean isDb2) {
        //Log.debug(filedType);
        if (filedType.equals("String")) {
            if (filedNm.endsWith("_ts")) {
                return isDb2 ? new String[]{"TIMESTAMP", ",-- 时间"} : new String[]{" DATETIME(6) ", "'1000-01-01 00:00:00' COMMENT '时间', "};
            }
            return new String[]{"VARCHAR(60)" + (isDb2 ? "" : " BINARY "), (isDb2 ? ", --" : "'' COMMENT '',")};
        } else if (filedType.equals("Integer")) {
            if (filedNm.equals("id")) {
                return isDb2 ? new String[]{"INTEGER GENERATED ALWAYS AS IDENTITY", ",-- "} : new String[]{" INT UNSIGNED AUTO_INCREMENT", " COMMENT '', "};
            }
            return isDb2 ? new String[]{"INTEGER", "0,-- "} : new String[]{" INT UNSIGNED ", "0 COMMENT '', "};
        } else if (filedType.equals("Long") || filedType.equals("BigInteger")) {
            if (filedNm.equals("id")) {
                return isDb2 ? new String[]{"INTEGER GENERATED ALWAYS AS IDENTITY", ",-- "} : new String[]{" BIGINT UNSIGNED AUTO_INCREMENT", " COMMENT '', "};
            }
            return isDb2 ? new String[]{"INTEGER", "0,-- "} : new String[]{" BIGINT UNSIGNED ", "0 COMMENT '', "};
        } else if (filedType.equals("Short")) {
            return isDb2 ? new String[]{"SMALLINT", "0,-- "} : new String[]{" SMALLINT UNSIGNED ", "0 COMMENT '', "};
        } else if (filedType.equals("Byte")) {
            return isDb2 ? new String[]{"SMALLINT", "0,-- "} : new String[]{" TINYINT(3) UNSIGNED ", "0 COMMENT '', "};
        } else if (filedType.equals("BigDecimal") || filedType.equals("Double") || filedType.equals("Float")) {
            return isDb2 ? new String[]{"DECIMAL(16,2)", "0,-- "} : new String[]{" DECIMAL(16,2)  ", "0 COMMENT '', "};
        }
        return null;
    }

    public static void gen2(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbv = new StringBuilder();
        sb.append("insert into <tbl> (").append(System.getProperty("line.separator"));
        byte i = 0;
        for (Field f : clazz.getDeclaredFields()) {
            if (f.isSynthetic() || f.isEnumConstant())
                continue;
            if (Modifier.isStatic(f.getModifiers()))
                continue;

            sb.append(StringUtil.toUnderlineCase(ClazzHelper.getSimpleLastName(f.getName()))).append(",");
            sbv.append("#{").append(ClazzHelper.getSimpleLastName(f.getName())).append("},");
            if (++i == 8) {
                i = 0;
                sb.append(System.getProperty("line.separator"));
                sbv.append(System.getProperty("line.separator"));
            }
        }
        sb.append(")").append(System.getProperty("line.separator"))
                .append("values(").append(System.getProperty("line.separator"));


        String sql = sb + sbv.toString() + ")";
        Log.debug(sql);
    }

}
