package cn.pengh.crypt.asymmetric;

import cn.pengh.library.Log;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;

/**
 * 国密算法，依赖bc加密包
 * org.bouncycastle:bcprov-jdk18on:$bcprov_version
 * @author Created by pengh
 * @datetime 2023/10/7 08:56
 */
public class SM3WithSM2 extends AbstractAsymmetricEncryptor implements IAsymmetricEncryptor {
    public static final String BC_PROVIDER_NAME = BouncyCastleProvider.PROVIDER_NAME;
    private static BouncyCastleProvider provider;

    static {
        try {
            provider = new BouncyCastleProvider();
            Security.addProvider(provider);
        } catch (Exception e) {
            Log.warn(e.getMessage());
        }
    }

    @Override
    protected String getCipherProvider() {
        return BC_PROVIDER_NAME;
    }

    @Override
    protected String getSignType() {
        return AsymmetricFactory.Algorithm.SM3SM2;
    }

    @Override
    protected String getAsymmetricKeyType() {
        return AsymmetricFactory.AsymmetricAlgorithm.EC;
    }

    @Override
    protected String getAsymmetricCipherAlgorithm() {
        return AsymmetricFactory.AsymmetricAlgorithm.SM2;
    }

    protected byte[] encryptIt(byte[] plain, PublicKey pubKey) throws Exception {
        return getPubEnCipher(pubKey).doFinal(plain);
    }

    protected byte[] decryptIt(byte[] encryptedData, PrivateKey priKey) throws Exception {
        return getPriDeCipher(priKey).doFinal(encryptedData);
    }


}
