package cn.pengh.crypt.asymmetric;

/**
 * @author Created by pengh
 * @datetime 2021/6/10 10:03
 */
public class SHA1WithRSA extends AbstractAsymmetricEncryptor implements IAsymmetricEncryptor {
    private static final int MAX_ENCRYPT_BLOCK_SIZE = 117; //RSA1最大加密明文大小(1024/8-11=117)
    private static final int MAX_DECRYPT_BLOCK_SIZE = 128; //RSA1最大解密密文大小(1024/8=128)

    @Override
    protected String getSignType() {
        return AsymmetricFactory.Algorithm.SHA128RSA;
    }

    @Override
    protected String getAsymmetricKeyType() {
        return AsymmetricFactory.AsymmetricAlgorithm.RSA;
    }

    @Override
    protected String getAsymmetricCipherAlgorithm() {
        return AsymmetricFactory.AsymmetricAlgorithm.RSA;
    }

    @Override
    protected int getMaxDecryptBlockSize() {
        return MAX_DECRYPT_BLOCK_SIZE;
    }

    @Override
    protected int getMaxEncryptBlockSize() {
        return MAX_ENCRYPT_BLOCK_SIZE;
    }
}
