package cn.pengh.crypt;

import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

/**
 * @author Created by pengh
 * @datetime 2024/4/10 11:33
 */
public class AesGcm {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH = 128;

    private static final byte[] IV_DEFAULT = "123-+abc".getBytes(StandardCharsets.UTF_8);

    /**
     * AES-256，需要1.8.0_162或以上版本，否则会抛出异常 java.security.InvalidKeyException: Illegal key size
     * @param associatedData AAD，额外的认证加密数据，可以为空
     * @param nonce          IV，随机字符串初始化向量
     * @param key            aes-192密钥的长度为24字节，aes-256密钥的长度为32字节，aes-128密码的长度为16字节
     * @param plaintext      UTF-8编码的明文
     * @return Java自带 base64密文，不换行
     */
    public static String encrypt(byte[] associatedData, byte[] nonce, byte[] key, byte[] plaintext) {
        try {
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(TRANSFORMATION);
            cipher.init(
                    javax.crypto.Cipher.ENCRYPT_MODE,
                    new SecretKeySpec(key, ALGORITHM),
                    new GCMParameterSpec(TAG_LENGTH, nonce));
            if (associatedData != null) {
                cipher.updateAAD(associatedData);
            }
            return Base64.getEncoder().encodeToString(cipher.doFinal(plaintext));
        } catch (Exception e) {
            e.printStackTrace();
            //throw new IllegalArgumentException(e);
            return null;
        }
    }


    /**
     * @param associatedData AAD，额外的认证加密数据，可以为空
     * @param nonce          IV，随机字符串初始化向量
     * @param key            aes-192密钥的长度为24字节，aes-256密钥的长度为32字节，aes-128密码的长度为16字节
     * @param ciphertext     base64后的密文，此处要先base64解密
     * @return
     */
    public static String decrypt(byte[] associatedData, byte[] nonce, byte[] key, String ciphertext) {
        try {
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(TRANSFORMATION);
            cipher.init(
                    javax.crypto.Cipher.DECRYPT_MODE,
                    new SecretKeySpec(key, ALGORITHM),
                    new GCMParameterSpec(TAG_LENGTH, nonce));
            if (associatedData != null) {
                cipher.updateAAD(associatedData);
            }
            return new String(cipher.doFinal(Base64.getDecoder().decode(ciphertext)), StandardCharsets.UTF_8);
        } catch (Exception e) {
            e.printStackTrace();
            //throw new IllegalArgumentException(e);
            return null;
        }
    }

    public static String encrypt(byte[] nonce, byte[] key, byte[] plaintext) {
        return encrypt(null, nonce, key, plaintext);
    }

    public static String decrypt(byte[] nonce, byte[] key, String ciphertext) {
        return decrypt(null, nonce, key, ciphertext);
    }

    public static String encrypt(byte[] key, byte[] plaintext) {
        return encrypt(IV_DEFAULT, key, plaintext);
    }

    public static String decrypt(byte[] key, String ciphertext) {
        return decrypt(IV_DEFAULT, key, ciphertext);
    }

}
