package cn.pengh.core.mqtt;

import cn.pengh.helper.CryptHelper;
import cn.pengh.util.JsonUtil;

import java.io.Serializable;

/**
 * @author Created by pengh
 * @datetime 2024/4/10 09:10
 */
public class MqttPayload implements Serializable {
    private static final long serialVersionUID = 9085461745090575484L;
    private String clientId;
    private String userName;
    private Integer code;
    private String desc;
    private String transNo;
    private String action;
    private String data;
    private String nonce;
    private Long timestamp;
    private String sign;

    /* auto generated by penghcn 24/04/11 08:56:54.792 */
    public MqttPayload setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }
    public String getClientId() {
        return this.clientId;
    }
    public MqttPayload setUserName(String userName) {
        this.userName = userName;
        return this;
    }
    public String getUserName() {
        return this.userName;
    }
    public MqttPayload setCode(Integer code) {
        this.code = code;
        return this;
    }
    public Integer getCode() {
        return this.code;
    }
    public MqttPayload setDesc(String desc) {
        this.desc = desc;
        return this;
    }
    public String getDesc() {
        return this.desc;
    }
    public MqttPayload setTransNo(String transNo) {
        this.transNo = transNo;
        return this;
    }
    public String getTransNo() {
        return this.transNo;
    }
    public MqttPayload setAction(String action) {
        this.action = action;
        return this;
    }
    public String getAction() {
        return this.action;
    }
    public MqttPayload setData(String data) {
        this.data = data;
        return this;
    }
    public String getData() {
        return this.data;
    }
    public MqttPayload setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }
    public String getNonce() {
        return this.nonce;
    }
    public MqttPayload setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }
    public Long getTimestamp() {
        return this.timestamp;
    }
    public MqttPayload setSign(String sign) {
        this.sign = sign;
        return this;
    }
    public String getSign() {
        return this.sign;
    }
    public MqttPayload() { }
    public static MqttPayload createDefault() {
        return new MqttPayload();
    }
    public MqttPayload build() {
        return new MqttPayload(clientId, userName, code, desc,
                transNo, action, data, nonce,
                timestamp, sign);
    }
    private MqttPayload(String clientId, String userName, Integer code, String desc,
                        String transNo, String action, String data, String nonce,
                        Long timestamp, String sign) {
        this.clientId = clientId;
        this.userName = userName;
        this.code = code;
        this.desc = desc;
        this.transNo = transNo;
        this.action = action;
        this.data = data;
        this.nonce = nonce;
        this.timestamp = timestamp;
        this.sign = sign;
    }

    public MqttPayload signEnd(char[] key) {
        this.sign = sign(this.clientId, key);
        return this;
    }

    /*
    2、签名规则
    先把data序列化成字符串，得到dataStr
    只拼接其值，每个值后面加上英文逗号
    topic,action,timestamp,nonce,dataStr,
    如上例得到待加密字符串s为
    mobin/host/88003003/event,login,1684203242527,zBuxyziAQldLgA9OXiIhK6zB7waNgvGT,{},
    使用sha256签名，key的值追加入待加密字符串s，假设key = 123$%#@^*abc，则
    sha256("mobin/host/88003003/event,login,1684203242527,zBuxyziAQldLgA9OXiIhK6zB7waNgvGT,{},123$%#@^*abc")
    即 0a4058d0195aae09fd5445127a164b796e7b3ce09f8f73396e9b4f3539a58f2c

     */
    private static final String SP = ",";

    /*
    sha256 签名
     */
    public String sign(String topic, char[] key) {
        if (topic == null || key == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(topic).append(SP)
                .append(wrap(this.action)).append(SP)
                .append(wrap(this.timestamp)).append(SP)
                .append(wrap(this.nonce)).append(SP)
                .append(wrapJson(this.data)).append(SP);
        return CryptHelper.sha256(sb.append(key).toString());
    }

    public boolean verify(String topic, char[] key, String sign) {
        return sign == null ? false : sign(topic, key).equals(sign.toLowerCase());
    }

    private static String wrap(Object s) {
        return s == null ? "" : s.toString();
    }

    private static String wrapJson(Object s) {
        return s == null ? "" : (s instanceof String ? (String) s : JsonUtil.toJson(s));
    }


}
