package cn.pengh.core.data.res;

import cn.pengh.library.Log;
import cn.pengh.util.CurrencyUtil;

/**
 * @author Created by pengh
 * @datetime 2017/9/29 16:01
 */
public class GpsRangeRes {
    private double lngWest;
    private double lngEast;
    private double latSouth;
    private double latNorth;

    public GpsRangeRes(double lngWest, double lngEast, double latSouth, double latNorth) {
        this.lngWest = lngWest;
        this.lngEast = lngEast;
        this.latSouth = latSouth;
        this.latNorth = latNorth;
    }

    public double getLngWest() {
        return lngWest;
    }

    public void setLngWest(double lngWest) {
        this.lngWest = lngWest;
    }

    public double getLngEast() {
        return lngEast;
    }

    public void setLngEast(double lngEast) {
        this.lngEast = lngEast;
    }

    public double getLatSouth() {
        return latSouth;
    }

    public void setLatSouth(double latSouth) {
        this.latSouth = latSouth;
    }

    public double getLatNorth() {
        return latNorth;
    }

    public void setLatNorth(double latNorth) {
        this.latNorth = latNorth;
    }

    public double getLngMin() {
        return lngWest;
    }
    public double getLngMax() {
        return lngEast;
    }
    public double getLatMin() {
        return latSouth;
    }
    public double getLatMax() {
        return latNorth;
    }

    public String getLngMinStr() {
        return CurrencyUtil.convertStrWithoutZero(lngWest,15);
    }
    public String getLngMaxStr() {
        return CurrencyUtil.convertStrWithoutZero(lngEast,15);
    }
    public String getLatMinStr() {
        return CurrencyUtil.convertStrWithoutZero(latSouth,15);
    }
    public String getLatMaxStr() {
        return CurrencyUtil.convertStrWithoutZero(latNorth,15).toString();
    }

    public static void main(String[] args) {
        Log.error(CurrencyUtil.convertStrWithoutZero(121.54134164097742,15));
        Log.error(CurrencyUtil.convertStr(121.5413416409774200,15));
        Log.error(CurrencyUtil.convert(131.23028668368200,15).toString());
    }
}
