package cn.pengh.core.constant;

/**
 * @author pengh
 * @Date 2017年10月23日 上午9:41:51
 */
public enum PayModeDetailEnum {
    WX_APP_PAY((short) 100, "微信APP支付", "微信支付", "APP", "APP", "WXAPP"),
    WX_JS_PAY((short) 101, "微信公众号支付", "微信支付", "JSAPI", "JSAPI", "WECHAT"),
    WX_WE_PAY((short) 102, "微信小程序支付", "微信支付", "JSAPI", "LETPAY", "WECHAT"),
    WX_QR_PAY((short) 103, "微信二维码支付", "微信支付", "NATIVE", "JSAPI", "WECHAT"),

    QQ_PAY((short) 40, "QQ页面支付", "QQ支付", "QQ", "QQ", "QQ"),
    QQ_JS_PAY((short) 50, "QQJS支付", "QQ支付", "QQJSAPI", "QQ", "QQ"),

    ALI_PAY((short) 60, "支付宝生活号(原服务窗)支付", "支付宝支付", "FWC", "ALIPAY", "ALIPAY"),
    ALI_APP_PAY((short) 61, "支付宝APP支付", "支付宝支付", "APP", "ALIPAY", "ALIPAY"),
    ALI_QR_PAY((short) 63, "支付宝扫码支付", "支付宝支付", "QR", "ALIPAY", "ALIPAY"),

    BAI_DU_WALLET_PAY((short) 80, "百度钱包支付", "百度支付", "JDJSAPI", "QQ", ""),

    JD_PAY((short) 90, "京东金融支付", "京东支付", "JDJSAPI", "JD", "JD"),

    FU_ICBC_PAY((short) 130, "工行APP支付", "富友支付", "", "", ""),
    FU_CMB_PAY((short) 131, "招行APP支付", "富友支付", "", "", ""),
    FU_CCB_PAY((short) 132, "建行APP支付", "富友支付", "", "", ""),
    FU_BOC_PAY((short) 133, "中行APP支付", "富友支付", "", "", ""),
    FU_ABC_PAY((short) 134, "农行APP支付", "富友支付", "", "", ""),
    FU_INSTALLMENT_PAY((short) 135, "信用卡分期", "富友支付", "", "", ""),
    FU_UNION_PAY((short) 136, "云闪付APP", "富友支付", "", "", ""),
    FU_QUICK_PAY((short) 137, "银行卡快捷支付", "富友支付", "", "", ""),
    FU_B2B_PAY((short) 138, "银行卡企业网银支付", "富友支付", "", "", ""),
    FU_B2C_PAY((short) 139, "银行卡个人网银支付", "富友支付", "", "", "");

    private short code;
    private String desc;
    private String shortDesc;
    private String tradeType;
    private String tradeTypeFuiou;
    private String orderTypeFuiou;

    private PayModeDetailEnum(short code, String desc, String shortDesc, String tradeType, String tradeTypeFuiou, String orderTypeFuiou) {
        this.code = code;
        this.desc = desc;
        this.shortDesc = shortDesc;
        this.tradeType = tradeType;
        this.tradeTypeFuiou = tradeTypeFuiou;
        this.orderTypeFuiou = orderTypeFuiou;
    }

    public short getCode() {
        return code;
    }

    public void setCode(short code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTradeType() {
        return tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public String getTradeTypeFuiou() {
        return tradeTypeFuiou;
    }

    public void setTradeTypeFuiou(String tradeTypeFuiou) {
        this.tradeTypeFuiou = tradeTypeFuiou;
    }

    public String getOrderTypeFuiou() {
        return orderTypeFuiou;
    }

    public void setOrderTypeFuiou(String orderTypeFuiou) {
        this.orderTypeFuiou = orderTypeFuiou;
    }

    public static String getDesc(short code) {
        return get(code).getDesc();
    }

    public String getShortDesc() {
        return shortDesc;
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    public static PayModeDetailEnum get(short code) {
        for (PayModeDetailEnum e : PayModeDetailEnum.values()) {
            if (code == e.getCode())
                return e;
        }
        return null;
    }

    public static PayModeDetailEnum getByName(String name) {
        for (PayModeDetailEnum e : PayModeDetailEnum.values()) {
            if (name.equals(e.toString()))
                return e;
        }
        return null;
    }
}


