package cn.pengh.util;

import cn.pengh.library.Log;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

import java.util.Arrays;
import java.util.HashSet;

/**
 * @author penghcn
 * @created 2016年3月1日上午11:36:54
 */
public class PinYinUtil {


    //http://www.open-open.com/lib/view/open1392087364364.html
    public static String getAllPinYin(String chinese) {
        return getAllPinYin(chinese, false);
    }

    public static String getAllPinYin(String chinese, boolean isEveryCapture) {
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        StringBuilder sb = new StringBuilder();
        char[] chineseChars = chinese.toCharArray();
        char pinyin;
        for (int i = 0; i < chineseChars.length; i++) {
            pinyin = chineseChars[i];
            if (pinyin > 128) {
                try {
                    //所有全拼
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray(pinyin, defaultFormat);
                    if (strs == null) {
                        continue;
                    }
                    HashSet<String> uniqueStrs = new HashSet<String>(Arrays.asList(strs));
                    int count = 0;
                    for (String str : uniqueStrs) {
                        if (count++ == 0) {
                            sb.append(isEveryCapture ? StringUtil.toCaptureName(str) : str);
                        } else {
                            sb.append("(").append(isEveryCapture ? StringUtil.toCaptureName(str) : str).append(")");
                        }
                    }
                } catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                } catch (Throwable e) {
                    Log.warn(e.getMessage());
                }
            } else {
                sb.append(pinyin);
            }
        }
        return sb.toString().replaceAll("\\)\\(", "/");
    }


    public static String getOnePinYin(String chinese) {
        return getOnePinYin(chinese, false);
    }

    public static String getOnePinYin(String chinese, boolean isEveryCapture) {
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        StringBuilder sb = new StringBuilder();
        char[] chineseChar = chinese.toCharArray();
        char pinyin;
        for (int i = 0; i < chineseChar.length; i++) {
            pinyin = chineseChar[i];
            if (pinyin > 128) {
                try {
                    //所有全拼
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray(pinyin, defaultFormat);
                    if (strs == null) {
                        continue;
                    }
                    sb.append(isEveryCapture ? StringUtil.toCaptureName(strs[0]) : strs[0]);
                } catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                } catch (Throwable e) {
                    Log.warn(e.getMessage());
                }
            } else {
                sb.append(pinyin);
            }
        }
        return sb.toString();
    }

    //汉字首字母
    public static String getOneCapturePinYin(String chinese) {
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        StringBuilder sb = new StringBuilder();
        char[] chineseChar = chinese.toCharArray();
        char pinyin;
        for (int i = 0; i < chineseChar.length; i++) {
            pinyin = chineseChar[i];
            if (pinyin > 128) {
                try {
                    //所有全拼
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray(pinyin, defaultFormat);
                    if (strs == null) {
                        continue;
                    }

                    sb.append(String.valueOf(strs[0].charAt(0)).toUpperCase());
                } catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                } catch (Throwable e) {
                    Log.warn(e.getMessage());
                }
            } else {
                sb.append(pinyin);
            }
        }
        return sb.toString();
    }
}
