package cn.pengh.library;

import cn.pengh.util.DateUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

import java.io.PrintStream;
/**
 * <h1>依赖spring-core</h1>
 * @author pengh
 * @Date 2016年6月28日 上午9:58:15
 */
public class Log {
	public static final boolean isLog4j2 = ClassUtils.isPresent("org.apache.logging.log4j.Logger", Log.class.getClassLoader());
	private static final Logger logger = isLog4j2 ? LogManager.getLogger(Log.class) : null;
	private static final org.slf4j.Logger slf4jLogger = isLog4j2 ? LoggerFactory.getLogger(Log.class) : null;

	private enum SYSTEM_PRINT {
		OUT,ERR
	};
	
	public static Logger getLogger() {
		if (!isLog4j2)
			throw new IllegalArgumentException("not support log4j2");
		return logger;
	}

	public static org.slf4j.Logger getSlf4jLogger() {
		if (!isLog4j2)
			throw new IllegalArgumentException("not support log4j2");
		return slf4jLogger;
	}
	
	public static void initSystemPrint(){
		System.setOut(getPrintStream(SYSTEM_PRINT.OUT));
		System.setErr(getPrintStream(SYSTEM_PRINT.ERR));
	}
	
	private static void printlnIntenal(Object msg,  String level) {
		System.out.println("--"+DateUtil.getCurrDay(DateUtil.FORMAT_LOG)+" "+level+" ["+Thread.currentThread().getName()+"]"+" [PS] "+msg);
	}
	
	private static PrintStream getPrintStream(final SYSTEM_PRINT level){
		return new PrintStream(SYSTEM_PRINT.ERR == level ? System.err : System.out) {
			private void printlnIntenal(Object msg) {
				if (SYSTEM_PRINT.ERR == level)
					error("[PS] "+msg);//通过error级别打印
				else 
					info("[PS] "+msg);//通过info级别打印
			}
			public void println(Object msg) {
				printlnIntenal(msg);
			}
			public void println(String msg) {
				printlnIntenal(msg);
			}
			public void println(boolean msg) {
				printlnIntenal(msg);
			}
			public void println(char msg) {
				printlnIntenal(Character.valueOf(msg));
			}
			public void println(char[] msg) {
				printlnIntenal(new String(msg));
			}
		};
	}
	
	public static void info(Object msg){
		if (isLog4j2)
			logger.info(msg);
		else
			printlnIntenal(msg,"INFO ");
	}
	public static void error(Object msg){
		if (isLog4j2)
			logger.error(msg);
		else
			printlnIntenal(msg,"ERROR");
	}
	
	public static void debug(Object msg){
		if (isLog4j2)
			logger.debug(msg);
		else
			printlnIntenal(msg,"DEBUG");
	}
	
	public static void trace(Object msg){
		if (isLog4j2)
			logger.trace(msg);
		else
			printlnIntenal(msg,"TRACE");
	}
	
	public static void warn(Object msg){
		if (isLog4j2)
			logger.warn(msg);
		else
			printlnIntenal(msg,"WARN ");
	}
	
	public static void main(String[] args) {
		System.out.println(isLog4j2);
		//System.setProperty(XMLConfigurationFactory.CONFIGURATION_FILE_PROPERTY, log4j2/Test03/Test03.xml);
		Logger logger = LogManager.getLogger();
		logger.trace("trace");
        logger.debug("debug");
        logger.info("hello");
        logger.warn("warn");
        logger.error("error");
        logger.fatal("fatal");
        
        logger.fatal("fatal,{},{}","test");
        
	}
}
