package cn.pengh.core.rpc;

import java.io.Serializable;

public class RpcResponse implements Serializable {
    private static final long serialVersionUID = 7703454032890723726L;
    private int code = 200;
    private String desc = "成功";

    public RpcResponse() {
    }

    public RpcResponse(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isSuccess() {
        return code == 200;
    }

    //http://tool.oschina.net/commons?type=5
    public boolean isBroadSuccess() {
        return isSuccess() || code == 202 || code == 205;
    }

    public static final RpcResponse create() {
        return new RpcResponse();
    }

    public static final RpcResponse create(String desc) {
        return new RpcResponse(200, desc);
    }

    public static final RpcResponse create(int code, String desc) {
        return new RpcResponse(code, desc);
    }

    public static final RpcResponse createErr(String desc) {
        return new RpcResponse(500, desc);
    }
}
