package cn.pengh.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 类freemarker 模板解析
 * #{name}
 * @author penghcn
 * @created 2016年2月15日下午1:44:29
 */
public class TemplateUtil {
    private static String CHARSET_DEFAULT = "utf-8";

    /**
     * t1: 支持模板注释 和 jsp 代码级别注释
     * <#-- freemarker 注释 -->
     * <%!-- jsp 代码级别 注释 -->
     *
     * @return
     * @throws URISyntaxException
     */
    public static String render(String filePath, Map<Object, Object> model) {
        return render(filePath, CHARSET_DEFAULT, model);
    }

    public static String render(String filePath, String encoding, Map<Object, Object> model) {
        if (null == encoding) {
            encoding = CHARSET_DEFAULT;
        }
        encoding = encoding.trim();
        StringBuilder str = new StringBuilder();
        FileInputStream fs = null;
        InputStreamReader isr = null;
        String content = null;
        try {
            fs = new FileInputStream(new File(filePath));
            isr = new InputStreamReader(fs, encoding);
            // 方法2：自己实现 buffer
            char[] buffer = new char[1024];
            int len = 0;
            while ((len = isr.read(buffer)) > 0) {
                str.append(buffer, 0, len);
            }

            content = str.toString();
            String parttern = "<#--[\\w\\W\r\\n]*?-->";
            Pattern p1 = Pattern.compile(parttern);
            Matcher m1 = p1.matcher(content);
            content = m1.replaceAll(""); //去掉模板注释

            // 处理模板变量 #{name} -->> 成功
            return renderStr(content, model);
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        } finally {
            try {
                if (isr != null)
                    isr.close();
                if (fs != null)
                    fs.close();
            } catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
        }
    }

    public static String renderStr(String content, String key, String value) {
        return renderStr(content, new HashMap<Object, Object>() {
            private static final long serialVersionUID = -3143440606254517970L; {
                put(key, value);
            }
        });
    }

    public static String renderStr(String content, Map<Object, Object> model) {
        // 处理模板变量 #{name} -->> 成功
        if (!(model != null && model.size() > 0)) {
            return content;
        }

        for (Map.Entry<Object, Object> entry : model.entrySet()) {
            String regex = "#\\{" + entry.getKey() + "\\}";
            content = content.replaceAll(regex, entry.getValue().toString());
        }
        return content;
    }
}
