package cn.pengh.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MapUtil {
	//key asc
	public static <K,V> Map<K,V> sortMapKey(Map<K,V> map){
		Map<K,V> treeMap = new TreeMap<K, V>(new Comparator<K>() {
			@Override
			public int compare(K o1, K o2) {
				return o1.toString().compareTo(o2.toString());
			}
		});
		treeMap.putAll(map);
		return treeMap;
	}
	
	//String val asc
	public static <K,V> Map<K,V> sortMapVal(Map<K,V> map){
		return sortMapValInternal(map, new Comparator<Map.Entry<K, V>>() {
			@Override
			public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
				return o1.getValue().toString().compareTo(o2.getValue().toString());
			}
		});
	}
	public static <K,V> Map<K,V> sortMapValDecimal(Map<K,V> map){
		return sortMapValInternal(map, new Comparator<Map.Entry<K, V>>() {
			@Override
			public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
				return CurrencyUtil.convert(o1.getValue(),64).compareTo(CurrencyUtil.convert(o2.getValue(),64));
			}
		});
	}
	
	public static <K> Map<K,Long> sortMapValLong(Map<K,Long> map){
		return sortMapValDecimal(map);
	}
	public static <K> Map<K,Double> sortMapValDouble(Map<K,Double> map){
		return sortMapValDecimal(map);
	}
	public static <K> Map<K,Float> sortMapValFloat(Map<K,Float> map){
		return sortMapValDecimal(map);
	}
	public static <K> Map<K,Integer> sortMapValInteger(Map<K,Integer> map){
		return sortMapValDecimal(map);
	}
	public static <K> Map<K,Short> sortMapValShort(Map<K,Short> map){
		return sortMapValDecimal(map);
	}
	public static <K> Map<K,Byte> sortMapValByte(Map<K,Byte> map){
		return sortMapValDecimal(map);
	}
	
	private static <K,V> Map<K,V> sortMapValInternal(Map<K,V> map,Comparator<Map.Entry<K, V>> comparator){
		final List<Map.Entry<K, V>> orders = new ArrayList<Map.Entry<K,V>>(map.entrySet());
		Collections.sort(orders, comparator);
		return new LinkedHashMap<K, V>(){
			private static final long serialVersionUID = -5199275723502189065L;{
				for (Map.Entry<K, V> entry : orders) {
					put(entry.getKey(), entry.getValue());
				}
			}
		};
	}
}
