package cn.pengh.util;

import cn.pengh.math.bd.DefaultUidGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 分布式Id
 * 百度uid https://github.com/baidu/uid-generator
 * 美团leaf https://github.com/Meituan-Dianping/Leaf
 * 滴滴tinyId https://github.com/didi/tinyid/wiki
 *
 * @author Created by pengh
 * @datetime 2021/6/8 15:05
 */
public class UidUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UidUtil.class);

    private static DefaultUidGenerator uidGenerator;
    public static String genUidStr() {
        return genUid() + "";
    }

    public static long genUid() {
        long uid = getInstance().getUID();
        //LOGGER.info(getInstance().parseUID(uid));
        return uid;
    }

    private static DefaultUidGenerator getInstance() {
        if (uidGenerator == null) {
            uidGenerator = new DefaultUidGenerator();
            uidGenerator.afterPropertiesSet();
        }
        return uidGenerator;
    }
}
