package cn.pengh.helper;

import cn.pengh.http.HttpRequest;
import cn.pengh.pbase.core.data.res.IpTaoBaoRes;
import cn.pengh.util.StringUtil;
import com.alibaba.fastjson.JSONArray;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

/**
 * @author Created by pengh
 * @datetime 2017/5/19 11:10
 */
public class IpHelper {
    @Deprecated
    public static IpTaoBaoRes getTaoBaoIp(final String ip) {
        String desc = HttpRequest.get("http://ip.taobao.com/service/getIpInfo2.php?ip=" + ip, HttpRequest.HttpRequestConfig.createDefault().setDebug(true));
        return desc == null ? null : JSONArray.parseObject(desc, IpTaoBaoRes.class);
    }

    public static String getLocalIp() {
        try {
            InetAddress result = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.isLoopbackAddress()) {
                        if (address.isSiteLocalAddress()) {
                            return address.getHostAddress();
                        } else if (result == null) {
                            result = address;
                        }
                    }
                }
            }
            return (result != null ? result : InetAddress.getLocalHost()).getHostAddress();
        } catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getLocalIpTail() {
        String ip = getLocalIp();
        return ip == null ? null : ip.split("\\.")[3];
    }

    public static String getLocalIpTail2() {
        String ip = getLocalIp();
        String[] arr = ip.split("\\.");
        return ip == null ? null : arr[2] + StringUtil.leftPadWithZero(arr[3], 3);
    }

    public static int getLocalIpTailInt() {
        String ipTail = getLocalIpTail();
        return ipTail == null ? 0 : Integer.valueOf(ipTail);
    }

    public static int getLocalIpTailInt2() {
        String ipTail = getLocalIpTail2();
        return ipTail == null ? 0 : Integer.valueOf(ipTail);
    }

    public static long ip2Num() {
        return ip2Num(getLocalIp());
    }

    public static long ip2Num(String ip) {
        String[] arr = ip.split("\\.");
        return arr.length != 4 ? 0 : Long.valueOf(arr[0]) * 256 * 256 * 256
                + Long.valueOf(arr[1]) * 256 * 256
                + Long.valueOf(arr[2]) * 256
                + Long.valueOf(arr[3]);
    }

}
