package cn.pengh.crypt.asymmetric;

/**
 * 非对称加解密、签名以及验证
 *
 * @author Created by pengh
 * @datetime 2021/6/10 09:56
 */
public interface IAsymmetricEncryptor {
    String CHARSET = "UTF-8";

    /**
     * 公钥 非对称加密
     *
     * @param plainText
     * @param publicKey
     * @param charset
     * @return base64加密后的字符串，不换行
     */
    String encrypt(String plainText, String publicKey, String charset);

    default String encrypt(String plainText, String publicKey) {
        return encrypt(plainText, publicKey, CHARSET);
    }

    /**
     * 私钥 非对称解密
     *
     * @param cipherText base64加密后的字符串，不换行
     * @param privateKey
     * @param charset
     * @return
     */
    String decrypt(String cipherText, String privateKey, String charset);

    default String decrypt(String cipherText, String privateKey) {
        return decrypt(cipherText, privateKey, CHARSET);
    }

    /**
     * 私钥 签名
     *
     * @param message
     * @param privateKey
     * @param charset
     * @return
     */
    String sign(String message, String privateKey, String charset);


    default String sign(String message, String privateKey) {
        return sign(message, privateKey, CHARSET);
    }

    /**
     * 公钥 验证签名
     *
     * @param message
     * @param publicKey
     * @param sign
     * @param charset
     * @return
     */
    boolean verify(String message, String publicKey, String sign, String charset);


    default boolean verify(String message, String publicKey, String sign) {
        return verify(message, publicKey, sign, CHARSET);
    }
}
