/**
 *
 */
package cn.pengh.util;

import cn.pengh.library.Log;

import java.io.UnsupportedEncodingException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author penghcn
 * @created 2014年12月29日下午4:16:37
 */
public class StringUtil {
    private static final String DELIMITER_COMMA = ",";

    public static String getRootPath() {
        String root = getClassPath();
        root = subStringEnd(root, 17);//17个字符为/WEB-INF/classes
        Log.info("获取项目根路径：" + root);
        return root;
    }

    public static String getClassPath() {
        return Thread.currentThread().getContextClassLoader().getResource("").getPath();
    }

    public static String subStringEnd(String str, int index) {
        return index < 0 ? str.substring(str.length() + index) : str.substring(0, str.length() - index);
    }

    public static <T> boolean isPrimitives(Class<T> clazz) {
        if (clazz.isPrimitive() || (clazz == Integer.class) || (clazz == Long.class)
                || (clazz == Byte.class) || (clazz == Float.class) || (clazz == Boolean.class)
                || (clazz == Double.class) || (clazz == Character.class) || (clazz == Short.class))
            return true;
        else
            return false;
    }

    public static List<String> getListByExceptKey(String exceptKey, String delimiter) {
        List<String> except = new ArrayList<String>();
        if (StringUtil.isEmpty(exceptKey))
            return except;
        else if (!exceptKey.contains(delimiter))
            except.add(exceptKey);
        else {
            String[] sp = exceptKey.split(delimiter);
            except.addAll(Arrays.asList(sp));
        }
        return except;
    }

    public static List<String> getListByExceptKey(String exceptKey) {
        return getListByExceptKey(exceptKey, DELIMITER_COMMA);
    }


    public static String getStringByList(Collection<String> ls) {
        return getStringByList(ls, DELIMITER_COMMA, "");
    }

    public static String getStringByList(Collection<String> ls, String quotation) {
        return getStringByList(ls, DELIMITER_COMMA, quotation);
    }

    public static String getSqlStringByList(Collection<String> ls) {
        return getStringByList(ls, DELIMITER_COMMA, "'");
    }

    /**
     * usage: getStringByList(ls,":","'")
     *
     * @param ls
     * @param delimiter
     * @param quotation
     * @return
     */
    public static String getStringByList(Collection<String> ls, String delimiter, String quotation) {
        StringBuilder sb = new StringBuilder();
        for (String s : ls) {
            sb.append(delimiter + quotation + s + quotation);
        }
        return sb.length() == 0 ? "" : sb.toString().substring(delimiter.length());
    }

    public static boolean isNotEmpty(String aStr) {
        return !isEmpty(aStr);
    }

    public static boolean isEmpty(String aStr) {
        return aStr == null || aStr.isEmpty();
    }

    public static boolean isEqual(String aStr, String refer) {
        return aStr != null && aStr.equals(refer);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !isBlank(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; i++) {
            if (!Character.isWhitespace(cs.charAt(i))) {
                return false;
            }
        }
        return true;
    }

    public static String truncate(String str, int len) {
        //int mixLen = mixLength(str);
        int strLen = str.length();
        if (strLen > len) {
            str = "<span title='" + str + "'>" + str.substring(0, len) + "...</span>";
        }
        //LogWriter.info(mixLen+",,"+strLen+"-------truncate------"+str);
        return str;
    }

    //pCal => p_cal
    public static String toUnderlineCase(String str) {
        return toUnderlineCase(str, false);
    }

    //true pCal5 => p_cal_5
    //bug? true pCal53 => p_cal_5_3
    public static String toUnderlineCase(String str, boolean isDigital) {
        StringBuilder sb = new StringBuilder();        
        /*for(int i = 0; i < str.length(); i++) {
            char ch = str.charAt(i);
            if(Character.isUpperCase(ch) || (ch >= 48 && ch <= 57 && isDigital)) {
            	sb.append('_');
            	sb.append(Character.toLowerCase(ch));
            	continue;
            }
            
            sb.append(ch);
        }*/


        char[] cs = str.toCharArray();
        for (char c : cs) {
            byte ascii = (byte) c;
            if (ascii >= 65 && ascii <= 90) {
                c += 32;
                sb.append('_').append(c);
            } else if ((ascii >= 48 && ascii <= 57) && isDigital) {
                sb.append('_').append(c);
            } else
                sb.append(c);
        }

        return sb.toString();
    }

    //p_cal => pCal
    public static String toCamelCase(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); i++) {
            char ch = str.charAt(i);
            if (ch == 95) {//'_' == 95
                if (++i >= str.length())
                    continue;
                sb.append(Character.toUpperCase(str.charAt(i)));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    //首字母大写
    //name => Name
    public static String toCaptureName(String name) {
        char[] cs = name.toCharArray();
        byte ascii = (byte) cs[0];
        //a == 97, z == 122
        if (ascii < 97 || ascii > 122)
            return name;

        cs[0] -= 32;
        return String.valueOf(cs);
    }

    //首字母小写
    //Name => name
    public static String toLowCaptureName(String name) {
        char[] cs = name.toCharArray();
        byte ascii = (byte) cs[0];
        //A == 65, Z == 90
        if (ascii < 65 || ascii > 90)
            return name;

        cs[0] += 32;
        return String.valueOf(cs);
    }
    
    /*public static List<List<String>> separateList(List<String> list,int limit) {
		int lsize = list.size();
		List<List<String>> ls = new ArrayList<List<String>>();
		if (lsize > limit){
			int N = lsize % limit == 0 ? lsize / limit : (lsize / limit + 1);
			for (int i = 0; i < N; i++) {
				List<String> tmp = new ArrayList<String>();
				int jstart = i*limit,jend = (i+1)*limit < lsize ? (i+1)*limit:lsize;
				for (int j = jstart; j < jend; j++){
					tmp.add(list.get(j));
				}				
				ls.add(tmp);
			}
		} else {
			ls.add(list);
		}
		return ls;
	}*/

    public static <T> List<List<T>> separateList(List<T> list, int limit) {
        int lsize = list.size();
        List<List<T>> ls = new ArrayList<List<T>>();
        if (lsize < limit) {
            ls.add(list);
            return ls;
        }
        if (lsize > limit) {
            int N = lsize % limit == 0 ? lsize / limit : (lsize / limit + 1);
            for (int i = 0; i < N; i++) {
                List<T> tmp = new ArrayList<T>();
                int jstart = i * limit, jend = (i + 1) * limit < lsize ? (i + 1) * limit : lsize;
                for (int j = jstart; j < jend; j++) {
                    tmp.add(list.get(j));
                }
                ls.add(tmp);
            }
        } else {
            ls.add(list);
        }
        return ls;
    }

    public static String right(final String str, final int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String rightPad(String aStr, int aSize) {
        return rightPad(aStr, aSize, " ");
    }

    public static String nvl(String src) {
        return StringUtil.isEmpty(src) ? "0" : src;
    }

    public static String leftPadWithZero(String aStr, int aSize) {
        return leftPad(aStr, aSize, "0");
    }

    public static String leftPad(String aStr, int aSize, String aDelim) {
        aSize = (aSize - aStr.length()) / aDelim.length();
        if (aSize > 0) {
            aStr = repeat(aDelim, aSize) + aStr;
        }
        return aStr;
    }

    public static String leftPad(String value, int len) {
        return StringUtil.isEmpty(value) ? left("?", len) : left(value, len);
    }

    public static String rightPad(String aStr, int aSize, String aDelim) {
        aSize = (aSize - aStr.length()) / aDelim.length();
        if (aSize > 0) {
            aStr = aStr + repeat(aDelim, aSize);
        }
        return aStr;
    }

    public static String rightPadWithSpace(String aStr, int aSize) {
        return rightPad(aStr, aSize, " ");
    }

    public static String repeat(String aStr, int aRepeat) {
        StringBuffer tBuffer = new StringBuffer(aRepeat * aStr.length());
        for (int i = 0; i < aRepeat; i++) {
            tBuffer.append(aStr);
        }
        return tBuffer.toString();
    }

    public static String left(String value, int len) {
        int vlen = 0;
        byte b[] = null;
        if (value != null) {
            b = value.getBytes();
            vlen = b.length;
        }
        if (vlen > len) {
            return (new String(b, 0, len));
        } else {
            return (new String(b, 0, vlen)) + getSpace(len - vlen);
        }
    }

    public static String delZeroFromLeft(String src) {
        StringBuffer sb = new StringBuffer(src);
        int len = sb.length();
        for (int i = 0; i < len; i++) {
            if (sb.charAt(0) == '0')
                sb.deleteCharAt(0);
            else
                return sb.toString();
        }
        return sb.toString();
    }

    private static String getSpace(int num) {
        return getSpace(num, " ");
    }

    private static String getSpace(int num, String defS) {
        if (num < 1)
            return "";
        StringBuffer sbspace = new StringBuffer("");
        byte b[] = defS.getBytes();
        int defSize = b.length;
        if (defSize == 1) {
            for (int k = 0; k < num; k++)
                sbspace.append(defS);
            return sbspace.toString();
        } else if (defSize > 1) {
            int intTimes = num / defSize;
            for (int k = 0; k < intTimes; k++)
                sbspace.append(defS);
            if ((intTimes = num % defSize) != 0)
                sbspace.append(new String(b, 0, intTimes));
            return sbspace.toString();
        } else
            return "";
    }

    public static String string2Unicode(String string) {
        StringBuilder unicode = new StringBuilder();
        for (int i = 0; i < string.length(); i++) {
            char c = string.charAt(i);

            //汉字范围 \u4e00-\u9fa5 (中文)
            if (c >= 19968 && c <= 171941) {
                unicode.append("u" + Integer.toHexString(c));// 转换为unicode
                continue;
            }
            unicode.append(c);
        }
        return unicode.toString();
    }

    public static String getFormatTimeStr(Long callTime) {
        if (callTime == null)
            callTime = 0L;
        long h = 0, m = 0, s = callTime % 60;
        if (callTime < 60) {
            //do nothing
        } else if (callTime < 3600) {
            m = callTime / 60;
        } else {
            m = (callTime / 60) % 60;
            h = callTime / 3600;
        }
        return addStrPre0(h) + ":" + addStrPre0(m) + ":" + addStrPre0(s);
    }

    public static String addStrPre0(long n) {
        return (n < 10 ? "0" : "") + n;
    }

    public static String addStrPre00(long n) {
        return (n < 10 ? "00" : (n < 100 ? "0" : "")) + n;
    }

    public static String addMaskStar(String str) {
        return addMaskStar(str, 4, 4);
    }

    public static String addMaskStar(String str, int start, int end) {
        return addMaskStar(str, start, end, '*');
    }

    /**
     *
     * @param str
     * @param start 前面留几个，<0 取0，即不留
     * @param end  后面留几个，<0 取0，即不留
     * @param maskStars
     * @return
     */
    public static String addMaskStar(String str, int start, int end, char maskStars) {
        if (str == null) {
            return null;
        }
        final int strLen = str.length(), maskStart = start < 0 ? 0 : start, maskEnd = strLen - (end < 0 ? 0 : end);
        if (maskEnd <= maskStart) {
            return str;
        }

        final char[] values = str.toCharArray();
        Arrays.fill(values, maskStart, maskEnd, maskStars);

        return new String(values);
    }


    @SuppressWarnings("unchecked")
    public static <T> T[] list2Array(Collection<T> ls) {
        if (ls == null)
            return null;
        return (T[]) ls.toArray();
    }

    private static final String _S_TOKEN_FLAG = "_";
    private static final int _S_TOKEN_STEP = 26;

    public static String encrypt(String ssoToken) {
        try {
            byte[] _ssoToken = ssoToken.getBytes("UTF-8");
            String name = new String();
            for (int i = 0; i < _ssoToken.length; i++) {
                int asc = _ssoToken[i];
                _ssoToken[i] = (byte) (asc + _S_TOKEN_STEP);
                name = name + (asc + _S_TOKEN_STEP) + _S_TOKEN_FLAG;
            }
            return name;
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }

    }

    public static String decrypt(String ssoToken) {
        if (ssoToken == null)
            return null;
        try {
            String name = new String();
            StringTokenizer st = new StringTokenizer(ssoToken, _S_TOKEN_FLAG);
            while (st.hasMoreElements()) {
                int asc = Integer.parseInt((String) st.nextElement()) - _S_TOKEN_STEP;
                name = name + (char) asc;
            }
            return name;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

    }

    public static <T> List<T> getDiffList(Collection<T> ls1, Collection<T> ls2) {
        //long bt = System.nanoTime();
        Log.getLogger().debug("ls1 size:{},ls2 size:{}", ls1.size(), ls2.size());

        Collection<T> maxList = ls1;
        Collection<T> minList = ls2;
        if (ls1.size() < ls2.size()) {
            maxList = ls2;
            minList = ls1;
        }


        List<T> diff = new ArrayList<T>();

        Map<T, Integer> map = new HashMap<T, Integer>(maxList.size());
        for (T e : maxList) {
            map.put(e, 1);
        }
        for (T e : minList) {
            if (map.get(e) != null) {
                map.put(e, 2);
                continue;
            }
            diff.add(e);
        }

        for (Map.Entry<T, Integer> entry : map.entrySet()) {
            if (entry.getValue() == 1)
                diff.add(entry.getKey());
        }

        //Log.debug("比较总耗时："+CurrencyUtil.divide((System.nanoTime() - bt),1e9,6)+"s");
        return diff;
    }


    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A
                || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION
                || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION
                || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
            return true;
        }
        return false;
    }

    //判断字符串是否是乱码
    public static boolean isMessyCode(String strName) {
        Pattern p = Pattern.compile("\\s*|t*|r*|n*");
        Matcher m = p.matcher(strName);
        String after = m.replaceAll("");
        String temp = after.replaceAll("\\p{P}", "");
        char[] ch = temp.trim().toCharArray();
        float chLength = ch.length;
        float count = 0;
        for (int i = 0; i < ch.length; i++) {
            char c = ch[i];
            if (!Character.isLetterOrDigit(c)) {
                if (!isChinese(c)) {
                    count = count + 1;
                }
            }
        }
        float result = count / chLength;
        if (result > 0.4) {
            return true;
        } else {
            return false;
        }

    }

    public static boolean containsEmoji(String source) {
        if (StringUtil.isEmpty(source)) {
            return false;
        }
        int len = source.length();
        for (int i = 0; i < len; i++) {
            char codePoint = source.charAt(i);
            if (isEmojiCharacter(codePoint)) {
                //do nothing，判断到了这里表明，确认有表情字符
                return true;
            }
        }
        return false;
    }

    private static boolean isEmojiCharacter(char codePoint) {
        return (codePoint == 0x0) ||
                (codePoint == 0x9) ||
                (codePoint == 0xA) ||
                (codePoint == 0xD) ||
                ((codePoint >= 0x20) && (codePoint <= 0xD7FF)) ||
                ((codePoint >= 0xE000) && (codePoint <= 0xFFFD)) ||
                ((codePoint >= 0x10000) && (codePoint <= 0x10FFFF));
    }

    /**
     * 过滤emoji 或者 其他非文字类型的字符
     * http://www.itmayun.com/it/files/226631678709806/article/406117164733730/1.html
     *
     * @param source
     * @return
     */
    public static String filterEmoji(String source) {
        source = source.replaceAll("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]", "*");
        if (!containsEmoji(source)) {
            return source;//如果不包含，直接返回
        }
        //到这里铁定包含
        StringBuilder buf = null;

        int len = source.length();

        for (int i = 0; i < len; i++) {
            char codePoint = source.charAt(i);

            if (isEmojiCharacter(codePoint)) {
                if (buf == null) {
                    buf = new StringBuilder(source.length());
                }

                buf.append(codePoint);
            } else {
                buf.append("*");
            }
        }

        if (buf == null) {
            return source;//如果没有找到 emoji表情，则返回源字符串
        } else {
            if (buf.length() == len) {//这里的意义在于尽可能少的toString，因为会重新生成字符串
                buf = null;
                return source;
            } else {
                return buf.toString();
            }
        }

    }

    public static String unicodeToCn(final String dataStr) {
        int start = 0;
        int end = 0;
        final StringBuilder buffer = new StringBuilder();
        while (start > -1) {
            end = dataStr.indexOf("\\u", start + 2);
            String charStr = "";
            if (end == -1) {
                charStr = dataStr.substring(start + 2, dataStr.length());
            } else {
                charStr = dataStr.substring(start + 2, end);
            }
            char letter = (char) Integer.parseInt(charStr, 16); // 16进制parse整形字符串。
            buffer.append(new Character(letter).toString());
            start = end;
        }
        return buffer.toString();
    }

    public static String cnToUnicode(String cn) {
        StringBuilder sb = new StringBuilder();
        char[] utfBytes = cn.toCharArray();
        for (int i = 0; i < utfBytes.length; i++) {
            String hexB = Integer.toHexString(utfBytes[i]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            sb.append("\\u" + hexB.toUpperCase());
        }
        return sb.toString();
    }


}
