package cn.pengh.helper;

import cn.pengh.annotation.ExceptField;
import cn.pengh.helper.ClazzHelper.MFVT;
import cn.pengh.util.StringUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import java.util.*;
/**
 * 
 * @author penghcn
 * @since  2014-8-13
 */
public class BeanPostHelper {
	@ExceptField
	public static final String _SEQUENCE_ = "@_SEQUENCE_@";	
	
	public static String toUpdateSet(Object obj,String... except) {
		if (except == null || except.equals(""))
			except = new String[]{};
		
		StringBuilder sb = new StringBuilder();
		List<MFVT> list = ClazzHelper.MV(obj);
		HashSet<String> fields = ClazzHelper.getAllFieldStrings(obj.getClass());
		for (MFVT mfvt : list) {
			String k = mfvt.getFieldName();
			Object v = mfvt.getValue();
			if (v == null)
				continue;		
			if (Arrays.asList(except).contains(k))
				continue;
			if (!fields.contains(k))
				continue;
			sb.append(StringUtil.toUnderlineCase(k)+" = :"+k+",");			
		}		
		return " set "+ sb.toString().replaceAll("(.*),$", "$1");
	}
	
	public static String toInsertSql(Object obj,String... except) {
		return toInsertSql(obj, true, true,false, except);
	}

	public static String toInsertSql(final Object obj,boolean isPrepare,boolean isUnderline,String... except) {
		return toInsertSql(obj,isPrepare,isUnderline,false,except) ;
	}
	/**
	 * 
	 * @param obj
	 * @param isPrepare 是否是预编译形式 :userName
	 * @param isUnderline 是否由驼峰转为下划线模式 user_name
	 * @param except
	 * @return
	 */
	public static String toInsertSql(final Object obj,boolean isPrepare,boolean isUnderline,boolean isDigital,String... except) {
		/*if (except == null || except.equals(""))
			except = new String[]{};
		List<MFVT> list = ClazzHelper.MV(obj);
		StringBuilder sbk = new StringBuilder();
		StringBuilder sbv = new StringBuilder();
		for (MFVT mfvt : list) {
			String key = mfvt.getFieldName();
			Object val = mfvt.getValue();
			if (val == null)
				continue;
			if (Arrays.asList(except).contains(key))
				continue;
			sbk.append(","+(isUnderline ? StringUtil.toUnderlineCase(key,isDigital) : key));
			if (isPrepare) {				
				sbv.append(",:"+key);
			} else {
				if ("String".equals(mfvt.getTypeSimpleName()) || "Date".equals(mfvt.getTypeSimpleName()))
					sbv.append(",'"+val+"'");
				else 
					sbv.append(","+val);
			}
		}
		if(sbk.length() == 0)
			throw new IllegalArgumentException("解析insert sql语句出错。");
		return "("+sbk.toString().substring(1)+") values ("+sbv.toString().substring(1)+")";*/
		
		return toBatchInsertSql(new ArrayList<Object>(){
			private static final long serialVersionUID = -2109122601153327988L;{
				add(obj);
			}
		}, isPrepare, isUnderline, isDigital, except);
	}
	
	public static <T>String toBatchInsertSql(List<T> objects,boolean isPrepare,boolean isUnderline,boolean isDigital,String... except) {
		if (except == null || except.equals(""))
			except = new String[]{};
		List<String> vs = new ArrayList<String>();
		StringBuilder sbk = new StringBuilder();
		int c = 0;
		for (Object obj : objects) {
			HashSet<String> fields = ClazzHelper.getAllFieldStrings(obj.getClass());
			List<MFVT> list = ClazzHelper.MV(obj);
			StringBuilder sbv = new StringBuilder();
			boolean isAddKey = false;
			if (c++ == 0)
				isAddKey = true;
			for (MFVT mfvt : list) {
				String key = mfvt.getFieldName();
				Object val = mfvt.getValue();
				if (val == null)
					continue;
				if (Arrays.asList(except).contains(key))
					continue;
				if (!fields.contains(key))
					continue;
				if (isAddKey)
					sbk.append(","+(isUnderline ? StringUtil.toUnderlineCase(key,isDigital) : key));
				if (isPrepare) {				
					sbv.append(",:"+key);
				} else {
					if ("String".equals(mfvt.getTypeSimpleName()) || "Date".equals(mfvt.getTypeSimpleName()))
						sbv.append(",'"+val+"'");
					else 
						sbv.append(","+val);
				}
			}
			vs.add(sbv.toString().substring(1));
		}
		String values = "";
		for (String v : vs) {
			values += ",("+v+")";
		}
		return "("+sbk.toString().substring(1)+") values "+values.substring(1);
	}
	
	/**
	 * 
	 * 另一种思路
	 * IdentityHashMap<String,Object> map = new IdentityHashMap<String,Object>();
        map.put(new String("fsString"), "first");
        map.put(new String("fsString"), "second");
        
        HashMap<String,List<Object>> mapList = new HashMap<String,List<Object>>();
        for (Entry<String, Object> entry : map.entrySet()) {
            System.out.println(entry.getKey() + "    "+entry.getValue());
        }
       ...
	 * 这个才是正确的，但依赖于guava的Multimap
	 * @param objects
	 * @param isPrepare
	 * @param isUnderline
	 * @param isDigital
	 * @param except
	 * @return
	 */
	public static <T>List<String> toBatchInsertSqlList(List<T> objects,boolean isPrepare,boolean isUnderline,boolean isDigital,String... except) {
		if (except == null || except.equals(""))
			except = new String[]{};		
		
		Multimap<String, String> kvMultimap = ArrayListMultimap.create();
		
		for (Object obj : objects) {
			List<MFVT> list = ClazzHelper.MV(obj);
			HashSet<String> fields = ClazzHelper.getAllFieldStrings(obj.getClass());
			StringBuilder sbv = new StringBuilder();
			StringBuilder sbk = new StringBuilder();
			for (MFVT mfvt : list) {
				String key = mfvt.getFieldName();
				Object val = mfvt.getValue();
				if (val == null)
					continue;
				if (Arrays.asList(except).contains(key))
					continue;
				if (!fields.contains(key))
					continue;
				sbk.append(","+(isUnderline ? StringUtil.toUnderlineCase(key,isDigital) : key));
				if (isPrepare) {				
					sbv.append(",:"+key);
				} else {
					if ("String".equals(mfvt.getTypeSimpleName()))
						sbv.append(",'"+val.toString().replaceAll("\'", "\\\\'")+"'");//转义单引号
					else if ("Date".equals(mfvt.getTypeSimpleName()))
						sbv.append(",'"+val+"'");//转义单引号
					else 
						sbv.append(","+val);
				}
			}
			kvMultimap.put(sbk.toString().substring(1), sbv.toString().substring(1));			
		}
		
		List<String> inserts = new ArrayList<String>();			
		for (String k : kvMultimap.keySet()) {
			Collection<String> v = kvMultimap.get(k);
			inserts.add(getInsertSqlByKV(k, v));
		}		
		return inserts;
	}
	
	
	private static String getInsertSqlByKV(String k,Collection<String> vs){
		String values = "";
		for (String v : vs) {
			values += ",("+v+")";
		}
		return "("+k+") values "+values.substring(1);
	}
	
	public static String toQuerySql(Object obj,String pre,String... except){
		if (except == null || except.equals(""))
			except = new String[]{};
		
		pre = toTblPre(pre);
		
		StringBuilder sb = new StringBuilder();		
		
		List<MFVT> list = ClazzHelper.MV(obj);
		HashSet<String> fields = ClazzHelper.getAllFieldStrings(obj.getClass());
		for (MFVT mfvt : list) {
			String k = mfvt.getFieldName();
			Object v = mfvt.getValue();
			if (v == null || v.toString().equals(""))
				continue;
			if (Arrays.asList(except).contains(k))
				continue;
			if (!fields.contains(k))
				continue;
			
			sb.append(" and "+pre+StringUtil.toUnderlineCase(k) + "= :"+k);
		}
		return sb.toString();
	}
	
	public static String toTblPre(String pre) {
		if (pre != null && !pre.equals("") && !pre.endsWith("."))
			pre += ".";
		return pre;
	}
	
	public static String toDB2PageSql(String sql) {
		return "SELECT * FROM(" + sql +") AS TBS_LIMIT WHERE TBS_LIMIT.RN BETWEEN :start AND :end";
	}	
	
}
