package cn.pengh.exception;


import cn.pengh.core.constant.ResponseCodeEnum;

/**
 * @author penghcn
 * @created 2015年12月15日下午5:56:13
 */
public class CustomException extends RuntimeException {
	/**
	 * 异常代码
	 */
	private int errCode = 500;
	private String errMessage = "系统异常";

	public CustomException() {}
	public CustomException(int errCode, String errMessage) {
		super(errMessage);
		this.errCode = errCode;
		this.errMessage = errMessage;
	}
	
	public CustomException(String errMessage) {
		super(errMessage);
		this.errMessage = errMessage;
	}

    public int getErrCode() {
        return errCode;
    }

	public String getErrCodeStr() {
		return errCode+"";
	}

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getErrMessage() {
        return errMessage;
    }

    public void setErrMessage(String errMessage) {
        this.errMessage = errMessage;
    }

    public String getMessage() {
		return errCode+" : "+super.getMessage();
	}
	
	public static CustomException create(){
		return new CustomException();
	}
	public static CustomException create(String errMessage){
		return new CustomException(errMessage);
	}
	public static CustomException create(int errCode,String errMessage){
		return new CustomException(errCode,errMessage);
	}
	public static CustomException create(ResponseCodeEnum res) {
		return new CustomException(res.getCode(), res.getDesc());
	}

	public static CustomException create(ResponseCodeEnum res, String msg) {
		return new CustomException(res.getCode(), res.getDesc() + " "+ msg);
	}

}
