package cn.pengh.library;

import cn.pengh.util.DateUtil;
import cn.pengh.util.StringUtil;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * 根据建表语句把对应字段拼成java field
 * jsqlparser
 * @author penghcn
 * @created 2016年2月2日下午4:53:44
 */
public class JavaFieldBuilder3 {
	private StringBuilder sb = new StringBuilder();
	private boolean isTestNull = false;

	public String parseFile2(File file){
		isTestNull = true;
		return parseFile(file);
	}
	
	public String parseFile(File file){
		sb.append("/* auto generated by penghcn "+DateUtil.getCurrDay("yyyy/MM/dd HH:mm:ss.SSS")+" */");
		sb.append(System.getProperty("line.separator"));
		
		BufferedReader scan = null;
		try {
			scan = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
			String line = null,fieldType = null,field = null;
			List<String> list = null, keys = new ArrayList<String>();
			while ((line = scan.readLine()) != null) {	
				if (!(line.indexOf(",") > -1))
					continue;
				list = new ArrayList<String>();
				for (String s : line.replaceAll("(.*)(,(\\s+)?)--(.*)", "$1").split(" ")) {
					if (!s.equals(""))
						list.add(s.trim().toLowerCase());
				}
				if (list.size() == 0)
					continue;
								
				//Log.debug(list);
				field = list.get(0);
				keys.add(field);
				
				if ("primary".equals(field) || "unique".equals(field))
					continue;
			}
			scan.close();


			sb.append("update <include refid=\"tbl\"/> set").append(System.getProperty("line.separator"));
			int count = 0;
			for (String key : keys) {

				if ("primary".equals(key))
					continue;

				if (isTestNull) {
					sb.append("<if test=\"").append(StringUtil.toCamelCase(key)).append(" != null\"> ")
							.append(key).append("= ").append("#{").append(StringUtil.toCamelCase(key)).append("}, ")
							.append("</if>").append(System.getProperty("line.separator"));

				} else {
					sb.append(key).append("= ").append("#{").append(StringUtil.toCamelCase(key)).append("}, ")
							.append(System.getProperty("line.separator"));
				}
				count++;
				if (count %8 == 0) {
					sb.append(System.getProperty("line.separator"));
				}
			}
			return sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		} finally {
			try {
				if(scan != null)
					scan.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
}
