package cn.pengh.http;

import cn.pengh.helper.ClazzHelper;
import cn.pengh.helper.JavaMethodBuilderHelper;
import cn.pengh.library.Log;
import cn.pengh.util.CurrencyUtil;
import cn.pengh.util.FileUtil;
import cn.pengh.util.StringUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ResourceUtils;

import javax.net.ssl.*;
import java.io.*;
import java.net.URLEncoder;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.*;

/**
 * httpclient 4.3+
 * https://github.com/apache/httpclient/
 * https://github.com/apache/httpcomponents-client/blob/1480958ce75c42977101432172e1245c3f555f5b/httpclient/src/examples/org/apache/http/examples/client/QuickStart.java
 *
 * @author penghcn
 * @created 2015年12月21日上午9:47:32
 */
public class HttpRequest implements Serializable {
    private static final long serialVersionUID = -1409714020256810180L;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final List<String> IMG_LIST = Arrays.asList("image/jpeg", "image/png", "image/gif");
    private static final List<String> GZIP_LIST = Arrays.asList("application/x-gzip");
    private static final List<String> ZIP_LIST = Arrays.asList("application/oct-stream", "x-zip-compressed");

    private static void _debug(HttpRequestConfig config, Object msg) {
        if (config.isDebug()) {
            Log.info(msg);
        } else if (Log.isLog4j2) {
            Logger logger = LogManager.getLogger(HttpRequest.class.getName());
            logger.debug(msg);
        }

    }

    public static String get(String url) {
        return doHttpRequest(new HttpGet(url), HttpRequestConfig.createDefault());
    }

    public static String get(String url, HttpRequestConfig config) {
        return doHttpRequest(new HttpGet(url), config);
    }

    public static String get(String url, Object params) {
        return get(url, params, HttpRequestConfig.createDefault());
    }

    public static String get(String url, Object params, HttpRequestConfig config) {
        if (params != null) {
            StringBuilder sb = new StringBuilder();
            Map<Object, Object> pm = ClazzHelper.KV(params);
            for (Map.Entry<Object, Object> e : pm.entrySet()) {
                sb.append("&").append(e.getKey()).append("=").append(encode(e.getValue().toString(), config.getCharset()));
            }
            /*if (params instanceof Map) {
                for (Map.Entry<String, String> e : pm.entrySet()) {
                    sb.append("&").append(e.getKey()).append("=").append(encode(e.getValue(), config.getCharset()));
                }
            } else {
                for (Map.Entry<Object,Object> e : ClazzHelper.KV(params)) {
                    if (mfvt.getValue() == null)
                        continue;
                    sb.append("&").append(mfvt.getFieldName()).append("=").append(encode(mfvt.getValue().toString(), config.getCharset()));
                }
            }*/
            url = url.indexOf("?") > -1 ? url + sb : url + "?" + sb.toString().substring(1);
        }
        HttpGet httpReq = new HttpGet(url);
        return doHttpRequest(httpReq, config);
    }

    private static String encode(String str, String charset) {
        try {
            return URLEncoder.encode(str, charset);//部分解决中文乱码，但还是强制建议使用post方法
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static String post(String url) {
        return post(url, null, HttpRequestConfig.createDefault());
    }

    public static String post(String url, HttpRequestConfig config) {
        return post(url, null, config);
    }

    public static String post(String url, Map<String, String> params) {
        return post(url, params, HttpRequestConfig.createDefault());
    }

    public static String post(String url, Object params) {
        return post(url, params, HttpRequestConfig.createDefault());
    }

    public static String post(String url, Object params, HttpRequestConfig config) {
        return postFormMap(url, ClazzHelper.KV(params), config);
    }

    public static String post(String url, final Map<String, String> params, HttpRequestConfig config) {
        /*HttpPost httpReq = new HttpPost(url);
        config.setHeaders(HTTP.CONTENT_TYPE, "application/x-www-form-urlencoded; charset=" + DEFAULT_CHARSET);
        try {
            if (params != null)
                httpReq.setEntity(new UrlEncodedFormEntity(new ArrayList<NameValuePair>() {
                    private static final long serialVersionUID = -372484766458709768L;

                    {
                        for (Map.Entry<String, String> entry : params.entrySet())
                            add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                    }
                }, config.getCharset()));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return doHttpRequest(httpReq, config);*/
        return postFormMap(url, ClazzHelper.KV(params), config);
    }

    public static String postFormMap(String url, final Map<Object, Object> params, HttpRequestConfig config) {
        HttpPost httpReq = new HttpPost(url);
        config.setHeaders(HTTP.CONTENT_TYPE, "application/x-www-form-urlencoded; charset=" + DEFAULT_CHARSET);
        try {
            if (params != null)
                httpReq.setEntity(new UrlEncodedFormEntity(new ArrayList<NameValuePair>() {
                    private static final long serialVersionUID = -1334101734900077138L;

                    {
                        for (Map.Entry<Object, Object> entry : params.entrySet())
                            add(new BasicNameValuePair(entry.getKey().toString(), entry.getValue().toString()));
                    }
                }, config.getCharset()));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return doHttpRequest(httpReq, config);
    }

    /**
     * 支持文件post
     *
     * @param url
     * @param params
     * @return
     */
    public static String postMulti(String url, Map<String, Object> params) {
        return postMulti(url, params, HttpRequestConfig.createDefault());
    }

    public static String postMulti(String url, Map<String, Object> params, HttpRequestConfig config) {
        HttpPost httpReq = new HttpPost(url);
        try {
            MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
            setMultiPostParams(mEntityBuilder, params, config);
            //浏览器兼容模式，防止中文乱码
            httpReq.setEntity(mEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE).build());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return doHttpRequest(httpReq, config);
    }

    public static String postJson(String url, String json) {
        return HttpRequest.postStream(url, json, HttpRequestConfig.createDefault().setHeaders(HTTP.CONTENT_TYPE, "application/json;charset=" + DEFAULT_CHARSET).build());
    }

    public static String postJson(String url, String json, HttpRequestConfig config) {
        return HttpRequest.postStream(url, json, config.setHeaders(HTTP.CONTENT_TYPE, "application/json;charset=" + DEFAULT_CHARSET).build());
    }

    public static String postStream(String url, String stream) {
        return postStream(url, stream, HttpRequestConfig.createDefault());
    }

    public static String postStream(String url, String stream, HttpRequestConfig config) {
        HttpPost httpPost = new HttpPost(url);

        StringEntity entity = new StringEntity(stream, config.getCharset());
        entity.setContentEncoding(config.getCharset());
        entity.setContentType(config.getHeaders().get(HTTP.CONTENT_TYPE));
        httpPost.setEntity(entity);
        return doHttpRequest(httpPost, config);
    }

    private static void setMultiPostParams(MultipartEntityBuilder mEntityBuilder, Map<String, Object> params, HttpRequestConfig config) {
        if (params == null)
            return;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof String) {
                String k;
                try {
                    k = URLEncoder.encode(entry.getKey(), config.getCharset());
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    k = entry.getKey();
                }
                mEntityBuilder.addTextBody(k, (String) v, ContentType.create("text/plain", config.getCharset()));
            } else if (v instanceof byte[])
                mEntityBuilder.addBinaryBody(entry.getKey(), (byte[]) v);
            else if (v instanceof File)
                mEntityBuilder.addBinaryBody(entry.getKey(), (File) v);
            else if (v instanceof InputStream)
                mEntityBuilder.addBinaryBody(entry.getKey(), (InputStream) v);
            //else
            //	continue;
        }
    }


    private static class PoolingHttpClientConnectionManagerSingletonLazyHolder {
        private static final PoolingHttpClientConnectionManager INSTANCE = new PoolingHttpClientConnectionManager();
    }

    private static CloseableHttpClient getHttpClient(HttpRequestConfig config) {
        RequestConfig requestConfig = RequestConfig.custom()
                .setSocketTimeout(config.getTimeout())
                .setConnectTimeout(config.getTimeout())
                .build();

        HttpClientBuilder httpClientBuilder = HttpClients.custom()
                .setRedirectStrategy(new LaxRedirectStrategy())//post 302 自动重定向
                .setUserAgent(config.getUserAgent())
                .setDefaultRequestConfig(requestConfig);

        if (config.getPoolSize() > 0) {
            PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerSingletonLazyHolder.INSTANCE;
            cm.setMaxTotal(config.getPoolSize());
            cm.setDefaultMaxPerRoute(config.getPoolSize());

            httpClientBuilder.setConnectionManager(cm);
        }

        setCustomSSL(httpClientBuilder, config);

        return httpClientBuilder.build();
    }

    private static CloseableHttpClient getHttpClient2(HttpRequestConfig config) {
        int connectTimeout = config.getTimeout() / 5; //连接超时，默认/5即可，最低100ms
        connectTimeout = connectTimeout == 0 ? 100 : connectTimeout;

        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(connectTimeout)
                .setSocketTimeout(config.getTimeout())
                .build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom()
                .setRedirectStrategy(new LaxRedirectStrategy())//post 302 自动重定向
                .setUserAgent(config.getUserAgent())
                .setMaxConnTotal(config.getPoolSize())
                .setMaxConnPerRoute(config.getPoolSize())
                .setDefaultRequestConfig(requestConfig);

        setCustomSSL(httpClientBuilder, config);

        return httpClientBuilder.build();
    }

    public static String doHttpRequest(HttpRequestBase httpReq, HttpRequestConfig config) {
        long st = System.nanoTime();

        CloseableHttpClient httpClient = getHttpClient2(config);

        try {
            _debug(config, "-->>SEND: " + httpReq.toString());
            if (httpReq instanceof HttpEntityEnclosingRequest) {
                HttpEntity en = ((HttpEntityEnclosingRequest) httpReq).getEntity();
                try {
                    en.getContent();
                    _debug(config, ("-->>PARAMS: " + (en == null ? "" : EntityUtils.toString(en))));
                } catch (Exception e) {
                    //Multipart form entity does not implement #getContent()
                    //e.printStackTrace();
                    Log.error(e.getMessage());
                    // do nothing
                }
            }

            httpReq.setHeader("referer", config.getReferer());
            for (Map.Entry<String, String> e : config.getHeaders().entrySet()) {
                httpReq.setHeader(e.getKey(), e.getValue());
            }
            //httpReq.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute(httpReq);
            _debug(config, "<<--RESPONSE: " + response.toString());
            FileOutputStream outImg = null;
            try {
                if (config.isForceStatus200() && response.getStatusLine().getStatusCode() != 200) {
                    _debug(config, "<<--RECEIVE CODE: " + response.getStatusLine().getStatusCode());
                    return null;
                }

                //返回图片格式
                Header[] headers = response.getHeaders("Content-Type");
                if (headers != null && headers.length > 0) {
                    String httpContentType = headers[0].getValue().toLowerCase();
                    if (IMG_LIST.contains(httpContentType)) {
                        String tmpImg = getTmpDownloadFile(config.downFileRoot, ".jpg");
                        downloadFile(response, config, tmpImg);
                        return FileUtil.getImageBase64(tmpImg);
                    }
                    if (GZIP_LIST.contains(httpContentType)) {
                        String tmpGzip = getTmpDownloadFile(config.downFileRoot, ".gzip");
                        downloadFile(response, config, tmpGzip);
                        return tmpGzip;
                    }
                    if (ZIP_LIST.contains(httpContentType)) {
                        String tmpZip = getTmpDownloadFile(config.downFileRoot, ".zip");
                        downloadFile(response, config, tmpZip);
                        return tmpZip;
                    }

                }

                HttpEntity entity = response.getEntity();
                String results = entity == null ? "" : EntityUtils.toString(entity, config.getCharset());
                _debug(config, "<<--RECEIVE: " + results);
                EntityUtils.consume(entity);//关闭HttpEntity流
                return results;
            } finally {
                response.close();
                if (outImg != null) {
                    outImg.close();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            try {
                httpClient.close();
                //httpReq.releaseConnection();
            } catch (Exception e) {
                e.printStackTrace();
            }
            _debug(config, "HttpClient Time elapsed: " + CurrencyUtil.divide(System.nanoTime() - st, 1e9, 6) + "s. URL: " + httpReq.getURI());
        }
    }


    private static String getTmpDownloadFile(String root, String tail) {
        String tmpFilePath = (root == null ? System.getProperty("java.io.tmpdir") : root) + "/file.tmp.file." + System.currentTimeMillis() + tail;
        return tmpFilePath;
    }

    private static boolean downloadFile(CloseableHttpResponse response, HttpRequestConfig config, String filePath) {
        _debug(config, filePath);
        try (InputStream is = response.getEntity().getContent(); FileOutputStream fos = new FileOutputStream(filePath)) {
            byte[] buf = new byte[FileUtil.BUFFER_LENGTH_64K];
            int len = 0;
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            fos.flush();
            return true;
        } catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void setCustomSSL(HttpClientBuilder httpClientBuilder, HttpRequestConfig config) {
        if (!config.isEnabledSSL())
            return;
        try {
            SSLContext sslcontext = null;
            if (config.getKeyStoreFile() != null) {
                sslcontext = getSSLContext(config.getKeyStoreFile(), config.getKeyStorePassword());
            } else if (StringUtil.isNotEmpty(config.getKeyStoreFilePath())) {
                sslcontext = getSSLContext(config.getKeyStoreFilePath(), config.getKeyStorePassword());
            } else {
                sslcontext = getSSLContext();
            }

            if (sslcontext == null)
                return;


            // Allow TLSv1 protocol only
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
                    sslcontext,
                    new String[]{"TLSv1.2", "TLSv1"},
                    null,
                    getDefaultHostnameVerifier());
            httpClientBuilder.setSSLSocketFactory(sslsf);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //SSLConnectionSocketFactory.getDefaultHostnameVerifier()
    private static HostnameVerifier getDefaultHostnameVerifier() {
        //return new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
        return new HostnameVerifier() {//just for test. Do not do this in production!!!
            public boolean verify(String string, SSLSession ssls) {
                return true;
            }
        };
    }

    //Although this will make your app vulnerable to man-in-the-middle attacks.
    //http://stackoverflow.com/questions/6047996/ignore-self-signed-ssl-cert-using-jersey-client
    //http://stackoverflow.com/questions/13626965/how-to-ignore-pkix-path-building-failed-sun-security-provider-certpath-suncertp
    private static SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{
                new X509TrustManager() {
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }
        };
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        return sc;
    }

    /**
     * getSSLContext("/app/cert/apiclient_cert.p12","123456");
     *
     * @param keyStoreFile
     * @param keyStorePassword
     * @return
     * @throws KeyManagementException
     * @throws NoSuchAlgorithmException
     * @throws KeyStoreException
     * @throws CertificateException
     * @throws IOException
     * @throws UnrecoverableKeyException
     */
    private static SSLContext getSSLContext(String keyStoreFile, String keyStorePassword)
            throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        return getSSLContext(ResourceUtils.getFile(keyStoreFile), keyStorePassword);
    }

    private static SSLContext getSSLContext(File keyStoreFile, String keyStorePassword)
            throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(new FileInputStream(keyStoreFile), keyStorePassword.toCharArray());

        //return SSLContexts.custom().loadTrustMaterial(new File(keyStoreFile), keyStorePassword.toCharArray(), new TrustSelfSignedStrategy()).build();

		/*SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(new TrustStrategy() {
			@Override
			public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
				return true;
			}
		}).loadKeyMaterial(keyStore, keyStorePassword.toCharArray()).build();*/

        return SSLContexts.custom().loadKeyMaterial(keyStore, keyStorePassword.toCharArray()).build();
    }


    public static class HttpRequestConfig implements Serializable {
        private static final long serialVersionUID = -6966588975227466998L;
        private int timeout = 10000; //10s
        private int poolSize = 64;
        private String charset = DEFAULT_CHARSET;
        private String referer = "https://g.pengh.cn";
        private String userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Safari/537.36";
        private boolean enabledSSL = true;
        private File keyStoreFile;
        private String keyStoreFilePath = "";
        private String keyStorePassword = "";
        private boolean forceStatus200 = true;
        private boolean debug = false;
        private String downFileRoot;
        private Map<String, String> headers = new HashMap<String, String>() {
            private static final long serialVersionUID = -3353464491703184389L;

            {
                put(HTTP.CONTENT_TYPE, "text/html; charset=" + DEFAULT_CHARSET);
            }
        };

        public HttpRequestConfig() {
        }

        private HttpRequestConfig(int timeout, int poolSize, String charset, String referer, String userAgent,
                                  boolean enabledSSL, File keyStoreFile, String keyStoreFilePath, String keyStorePassword, Map<String, String> headers,
                                  boolean forceStatus200, boolean debug, String downFileRoot) {
            this.timeout = timeout;
            this.poolSize = poolSize;
            this.referer = referer;
            this.charset = charset;
            this.userAgent = userAgent;
            this.enabledSSL = enabledSSL;
            this.keyStoreFile = keyStoreFile;
            this.keyStoreFilePath = keyStoreFilePath;
            this.keyStorePassword = keyStorePassword;
            this.headers = headers;
            this.forceStatus200 = forceStatus200;
            this.debug = debug;
            this.downFileRoot = downFileRoot;
        }

        public static HttpRequestConfig createDefault() {
            return new HttpRequestConfig();
        }

        public HttpRequestConfig build() {
            return new HttpRequestConfig(timeout, poolSize, charset, referer, userAgent, enabledSSL,
                    keyStoreFile, keyStoreFilePath, keyStorePassword, headers, forceStatus200, debug, downFileRoot);
        }


        public String getDownFileRoot() {
            return this.downFileRoot;
        }

        public HttpRequestConfig setDownFileRoot(String downFileRoot) {
            this.downFileRoot = downFileRoot;
            return this;
        }

        public int getTimeout() {
            return timeout;
        }

        public HttpRequestConfig setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public int getPoolSize() {
            return poolSize;
        }

        public HttpRequestConfig setPoolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public String getCharset() {
            return charset;
        }

        public HttpRequestConfig setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public String getReferer() {
            return referer;
        }

        public HttpRequestConfig setReferer(String referer) {
            this.referer = referer;
            return this;
        }

        public String getUserAgent() {
            return userAgent;
        }

        public HttpRequestConfig setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public boolean isEnabledSSL() {
            return enabledSSL;
        }

        public HttpRequestConfig EnabledSSL() {
            this.enabledSSL = true;
            return this;
        }

        public HttpRequestConfig setEnabledSSL(boolean enabledSSL) {
            this.enabledSSL = enabledSSL;
            return this;
        }

        public File getKeyStoreFile() {
            return keyStoreFile;
        }

        public HttpRequestConfig setKeyStoreFile(File keyStoreFile) {
            this.keyStoreFile = keyStoreFile;
            return this;
        }

        public String getKeyStoreFilePath() {
            return keyStoreFilePath;
        }

        public HttpRequestConfig setKeyStoreFilePath(String keyStoreFilePath) {
            this.keyStoreFilePath = keyStoreFilePath;
            return this;
        }

        public String getKeyStorePassword() {
            return keyStorePassword;
        }

        public HttpRequestConfig setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Map<String, String> getHeaders() {
            return headers;
        }

        public HttpRequestConfig setHeaders(Map<String, String> headers) {
            if (headers != null) {
                this.headers.putAll(headers);
            }
            return this;
        }

        public HttpRequestConfig setHeaders(final String header, final String value) {
            this.headers.put(header, value);
            return this;
        }

        public boolean isForceStatus200() {
            return forceStatus200;
        }

        public HttpRequestConfig setForceStatus200(boolean forceStatus200) {
            this.forceStatus200 = forceStatus200;
            return this;
        }

        public boolean isDebug() {
            return debug;
        }

        public HttpRequestConfig setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        private String toHash() {
            String hash = timeout + poolSize + charset + referer + userAgent + enabledSSL +
                    keyStoreFile + keyStoreFilePath + keyStorePassword + forceStatus200 + debug;
            for (Map.Entry h : headers.entrySet()) {
                hash += h.getKey() + "--" + h.getValue();
            }
            return hash;
        }

        public static void main(String[] args) {
            JavaMethodBuilderHelper.gen(HttpRequestConfig.class);
        }

    }
}
