package cn.pengh.crypt.asymmetric;

/**
 * 公钥加密、私钥解密。3种填充 RSA_PKCS1_OAEP_PADDING、RSA_PKCS1_PADDING、RSA_NO_PADDING
 * 默认RSA_NO_PADDING，推荐OAEP ，见SHA256WithRSAPaddingOAEP
 * @author Created by pengh
 * @datetime 2021/6/10 10:03
 */
public class SHA256WithRSA extends SHA1WithRSA implements IAsymmetricEncryptor {
    private static final int MAX_ENCRYPT_BLOCK_SIZE = 244; //RSA2最大加密明文大小(2048/8-11=244)
    private static final int MAX_DECRYPT_BLOCK_SIZE = 256; //RSA2最大解密密文大小(2048/8=256)

    @Override
    protected String getSignType() {
        return AsymmetricFactory.Algorithm.SHA256RSA;
    }

    @Override
    protected int getMaxDecryptBlockSize() {
        return MAX_DECRYPT_BLOCK_SIZE;
    }

    @Override
    protected int getMaxEncryptBlockSize() {
        return MAX_ENCRYPT_BLOCK_SIZE;
    }
}
