package cn.pengh.core.data.res;

import cn.pengh.core.constant.ResponseCodeEnum;

import java.util.List;

public class RestResBuilder {
    public static RestfulResponse build() {
        return build(ResponseCodeEnum.SUCCESS.getDesc());
    }
    public static RestfulResponse buildNoDesc() {
        return build(ResponseCodeEnum.SUCCESS.getCode(), null);
    }
    public static RestfulResponse build(String desc) {
        return build(ResponseCodeEnum.SUCCESS.getCode(), desc);
    }

    public static RestfulResponse build(int code, String desc) {
        return new RestfulResponse(code, desc);
    }

    public static RestfulResponse build(IRestResData data) {
        return RestfulResponse.create(ResponseCodeEnum.SUCCESS.getCode(), ResponseCodeEnum.SUCCESS.getDesc()).setData(data);
    }

    public static RestfulResponse build(List<?> list) {
        return build(list, null);
    }

    public static RestfulResponse build(List<?> list, Long totalCount) {
        return build(new RestResDatas(list)).setTotalCount(totalCount).build();
    }

    public static RestfulResponse build(ResponseCodeEnum responseCode) {
        return RestfulResponse.create(responseCode.getCode(), responseCode.getDesc());
    }
    public static RestfulResponse buildErr(String desc) {
        return RestfulResponse.create(ResponseCodeEnum.ERROR_500.getCode(), desc);
    }
    public static RestfulResponse buildErr() {
        return RestfulResponse.create(ResponseCodeEnum.ERROR_500.getCode(), ResponseCodeEnum.ERROR_500.getDesc());
    }
    public static RestfulResponse buildErrNoDesc() {
        return RestfulResponse.create(ResponseCodeEnum.ERROR_500.getCode(), null);
    }
}
