package cn.pengh.io.json;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author Created by pengh
 * @datetime 2023/6/20 16:13
 */
public class MaskDataConfig<T> {
    private static final Set<String> MASK_FIELDS = new HashSet<>(Arrays.asList(
            "password", "loginPassword", "pwd", "loginPwd", "loginPwdOld", "loginPassword",
            "secret", "token", "accessToken", "pkgToken",
            "appKey", "lastAppKey", "rsa2PriKey", "rsa2PubKey"));
    private final T data;
    private final Set<String> maskFields;


    /**
     * -1, null，某情况下忽略该字段
     * 0, 默认，******
     * <p>
     * 4, ****1111, 保留后4位
     * 34, 111****1111, 保留前3后4位
     */
    private final byte type; //0,1,4,34


    public MaskDataConfig(T data, Set<String> fields, byte type) {
        this.data = data;
        this.maskFields = fields;
        this.type = type;
    }

    public MaskDataConfig(T data, List<String> fields, byte type) {
        this.data = data;
        this.maskFields = new HashSet<>(fields);
        this.type = type;
    }

    public MaskDataConfig(T data, List<String> fields) {
        this.data = data;
        this.maskFields = new HashSet<>(fields);
        this.type = 0;
    }

    public MaskDataConfig(T data) {
        this.data = data;
        this.maskFields = MASK_FIELDS;
        this.type = 0;
    }

    public T getData() {
        return data;
    }

    public Set<String> getMaskFields() {
        return maskFields;
    }

    public byte getType() {
        return type;
    }
}
