package cn.pengh.helper;

import cn.pengh.library.JavaMethodBuilder;
import cn.pengh.library.Log;
import cn.pengh.util.FileUtil;
import cn.pengh.util.StringUtil;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

/**
 * @author Created by pengh
 * @datetime 2017/5/11 10:27
 */
public class JavaMethodBuilderHelper {
    private static String TMP_FILE = System.getProperty("java.io.tmpdir")+"/JavaMethodBuilderHelper.tmp.file";

    public static void gen(String clazzName, String filePath) {
        String s = JavaMethodBuilder.createDefault()
                .setClazzName(clazzName)
                .setConstruct(true)
                .setReturnThis(true)
                .setGet(true)
                .build()
                .parseFile(new File(filePath));
        System.out.printf(s);
    }

    public static void gen(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        for (Field f : clazz.getDeclaredFields()) {
            if (f.isSynthetic() || f.isEnumConstant())
                continue;
            if (Modifier.isStatic(f.getModifiers()))
                continue;

            sb.append("private ")
                    .append(getSimpleName(f.getGenericType().getTypeName()))
                    .append(" ")
                    .append(ClazzHelper.getSimpleLastName(f.getName()))
                    .append(";")
                    .append(System.getProperty("line.separator"));
        }

        //Log.debug(sb.toString());
        FileUtil.WriteContentsToFile(TMP_FILE, sb.toString());

        gen(ClazzHelper.getSimpleLastName(clazz.getName()), TMP_FILE);
    }

    //java.util.Map<java.lang.String, cn.pengh.mvc.simple.wx.req.WxTmplMsgData> data
    private static String getSimpleName(String str) {
        return str.replaceAll("([\\w_\\d]+\\.)?","").replaceAll(", ",",").replaceAll("\\$","\\.");
    }

    public static void main(String[] args) {
        String s = "java.util.Map<java._lang._String, cn.pengh.mvc123.simple.wx.req.WxTmplMsgData$String> data";
        Log.error(getSimpleName(s));

        //gen(RestfulResponse.class);
    }

    public static void gen2(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbv = new StringBuilder();
        sb.append("insert into tbl(").append(System.getProperty("line.separator"));
        for (Field f : clazz.getDeclaredFields()) {
            if (f.isSynthetic() || f.isEnumConstant())
                continue;
            if (Modifier.isStatic(f.getModifiers()))
                continue;
            sb.append(StringUtil.toUnderlineCase(ClazzHelper.getSimpleLastName(f.getName()))).append(",");
            sbv.append("#{").append(ClazzHelper.getSimpleLastName(f.getName())).append("},");
        }
        sb.append(")").append(System.getProperty("line.separator"))
                .append("values(").append(System.getProperty("line.separator"));


        String sql = sb.toString() + sbv.toString()+")";
        Log.debug(sql);
    }

}
