package cn.pengh.crypt.asymmetric;

/**
 * @author Created by pengh
 * @datetime 2021/10/9 17:10
 */
public class SHA512WithRSA extends SHA256WithRSA implements IAsymmetricEncryptor {
    private static final int MAX_ENCRYPT_BLOCK_SIZE = 501; //RSA4最大加密明文大小(4096/8-11)
    private static final int MAX_DECRYPT_BLOCK_SIZE = 512; //RSA4最大解密密文大小(4096/8)

    @Override
    protected String getSignType() {
        return AsymmetricFactory.Algorithm.SHA512RSA;
    }

    @Override
    protected int getMaxDecryptBlockSize() {
        return MAX_DECRYPT_BLOCK_SIZE;
    }

    @Override
    protected int getMaxEncryptBlockSize() {
        return MAX_ENCRYPT_BLOCK_SIZE;
    }
}
