package cn.pengh.crypt.asymmetric;

import cn.pengh.exception.CustomException;

/**
 * @author Created by pengh
 * @datetime 2021/6/10 15:04
 */
public class AsymmetricFactory {
    private static final class SHA256RSALazyHolder {
        private static final SHA256WithRSA INSTANCE = new SHA256WithRSA();
    }

    private static final class SHA256RSAPaddingOAEPLazyHolder {
        private static final SHA256WithRSAPaddingOAEP INSTANCE = new SHA256WithRSAPaddingOAEP();
    }

    private static final class SHA128RSALazyHolder {
        private static final SHA1WithRSA INSTANCE = new SHA1WithRSA();
    }

    private static final class SHA512RSALazyHolder {
        private static final SHA512WithRSA INSTANCE = new SHA512WithRSA();
    }
    private static final class SHA512RSAPaddingOAEPLazyHolder {
        private static final SHA512WithRSAPaddingOAEP INSTANCE = new SHA512WithRSAPaddingOAEP();
    }

    private static final class SHA256EcDsaLazyHolder {
        private static final SHA256withECDSA INSTANCE = new SHA256withECDSA();
    }

    public static IAsymmetricEncryptor getByName(String type) {
        switch (type) {
            case Algorithm.SHA256RSA:
            case Algorithm.RSA2:
                return SHA256RSALazyHolder.INSTANCE;
            case Algorithm.SHA256RSA_OAEP:
                return SHA256RSAPaddingOAEPLazyHolder.INSTANCE;
            case Algorithm.SHA128RSA:
            case Algorithm.RSA:
                return SHA128RSALazyHolder.INSTANCE;
            case Algorithm.SHA256ECDSA:
                return SHA256EcDsaLazyHolder.INSTANCE;
            case Algorithm.SHA512RSA:
                return SHA512RSALazyHolder.INSTANCE;
            case Algorithm.SHA512RSA_OAEP:
                return SHA512RSAPaddingOAEPLazyHolder.INSTANCE;
            default:
                throw CustomException.create("无效的非对称加密类型:[\" + type + \"]，可选值为：RSA,RSA2,SHA256WithRSA,SHA256WithRSA_OAEP,SHA1WithRSA,SHA256withECDSA,SHA512RSA,SHA512WithRSA_OAEP");
        }
    }


    public static final class Algorithm {
        public static final String SHA256RSA = "SHA256WithRSA"; //sha256,rsa2048
        public static final String SHA256RSA_OAEP = "SHA256WithRSA_OAEP"; //sha256,oaep,rsa2048
        public static final String SHA512RSA = "SHA512WithRSA"; //sha512,rsa4096
        public static final String SHA512RSA_OAEP = "SHA512WithRSA_OAEP"; //sha512,oaep,rsa4096
        public static final String SHA128RSA = "SHA1WithRSA";
        public static final String MD5RSA = "MD5WithRSA";
        public static final String SHA256ECDSA = "SHA256withECDSA";

        public static final String RSA = "RSA";
        public static final String RSA2 = "RSA2";
        public static final String RSA4 = "RSA4";
    }

    public static final class AsymmetricAlgorithm {
        public static final String RSA = "RSA";
        public static final String RSA_PKCS1_OAEP_PADDING = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";

        public static final String EC = "EC";
    }
}
