package cn.pengh.crypt;


import cn.pengh.util.ArrayUtil;

import java.nio.ByteBuffer;

/**
 * 10进制数字 转62、64 等
 *
 *
 * @author Created by pengh
 * @datetime 2023/5/12 16:06
 */
public class Encode10 {
    private static final char[] CHARS_09_AZ_az = {
            (byte) '0', (byte) '1', (byte) '2', (byte) '3', (byte) '4', (byte) '5', (byte) '6', (byte) '7',
            (byte) '8', (byte) '9', (byte) 'A', (byte) 'B', (byte) 'C', (byte) 'D', (byte) 'E', (byte) 'F',
            (byte) 'G', (byte) 'H', (byte) 'I', (byte) 'J', (byte) 'K', (byte) 'L', (byte) 'M', (byte) 'N',
            (byte) 'O', (byte) 'P', (byte) 'Q', (byte) 'R', (byte) 'S', (byte) 'T', (byte) 'U', (byte) 'V',
            (byte) 'W', (byte) 'X', (byte) 'Y', (byte) 'Z', (byte) 'a', (byte) 'b', (byte) 'c', (byte) 'd',
            (byte) 'e', (byte) 'f', (byte) 'g', (byte) 'h', (byte) 'i', (byte) 'j', (byte) 'k', (byte) 'l',
            (byte) 'm', (byte) 'n', (byte) 'o', (byte) 'p', (byte) 'q', (byte) 'r', (byte) 's', (byte) 't',
            (byte) 'u', (byte) 'v', (byte) 'w', (byte) 'x', (byte) 'y', (byte) 'z'
    };
    private static final byte[] BYTES64_09_AZ_az_ = {
            (byte) '0', (byte) '1', (byte) '2', (byte) '3', (byte) '4', (byte) '5', (byte) '6', (byte) '7',
            (byte) '8', (byte) '9', (byte) 'A', (byte) 'B', (byte) 'C', (byte) 'D', (byte) 'E', (byte) 'F',
            (byte) 'G', (byte) 'H', (byte) 'I', (byte) 'J', (byte) 'K', (byte) 'L', (byte) 'M', (byte) 'N',
            (byte) 'O', (byte) 'P', (byte) 'Q', (byte) 'R', (byte) 'S', (byte) 'T', (byte) 'U', (byte) 'V',
            (byte) 'W', (byte) 'X', (byte) 'Y', (byte) 'Z', (byte) 'a', (byte) 'b', (byte) 'c', (byte) 'd',
            (byte) 'e', (byte) 'f', (byte) 'g', (byte) 'h', (byte) 'i', (byte) 'j', (byte) 'k', (byte) 'l',
            (byte) 'm', (byte) 'n', (byte) 'o', (byte) 'p', (byte) 'q', (byte) 'r', (byte) 's', (byte) 't',
            (byte) 'u', (byte) 'v', (byte) 'w', (byte) 'x', (byte) 'y', (byte) 'z', (byte) '-', (byte) '_'
    };

    private static int ENCODE_62_LENGTH_MAX = 11; //long数字转62进制，最长11位
    private static int ENCODE_62_LENGTH_MIN = 5; //long数字转62进制，最短5位，不足前面补0
    private static int ENCODE_62 = 62;
    private static int ENCODE_62_BREAK_61 = ENCODE_62 - 1;

    private static int ENCODE_64 = 64;
    private static int ENCODE_63 = 63;

    /**
     * 数字转62进制
     * 求余，末位追加，最后需反转
     *
     * @param n
     * @return
     */
    public static String encode62(long n) {
        /* //多循环一次
        StringBuilder sb = new StringBuilder(ENCODE_62_LENGTH_MAX);
        while (n > 0) {
            sb.append(CHARS_09_AZ_az[(int)(n % ENCODE_62)]);
            n = n / ENCODE_62;
        }
        return sb.reverse().toString();*/
        StringBuilder sb = new StringBuilder(ENCODE_62_LENGTH_MAX);
        while (n > ENCODE_62_BREAK_61) {
            sb.append(CHARS_09_AZ_az[Long.valueOf(n % ENCODE_62).intValue()]);
            n = n / ENCODE_62;
        }
        sb.append(CHARS_09_AZ_az[Long.valueOf(n).intValue()]);
        return sb.reverse().toString();
    }

    /*public static String encode64(long n) {
        StringBuilder sb = new StringBuilder(ENCODE_62_LENGTH_MAX);
        while (n > 0) {
            sb.append(CHARS_09_AZ_az_[(int) (n % ENCODE_64)]);
            n = n / ENCODE_64;
        }
        return sb.reverse().toString();
    }*/
    public static String encode64(long n) {
        return encode64(n, 0);
    }

    //加上偏移量，防止逆编码
    public static String encode64(long n, int offset) {
        return encode6234(n, offset, ENCODE_64);
    }

    public static String encode63(long n, int offset) {
        return encode6234(n, offset, ENCODE_63);
    }

    public static String encode62(long n, int offset) {
        return encode6234(n, offset, ENCODE_62);
    }

    public static String encode63(long n) {
        return encode63(n, 0);
    }

    /**
     * @param n
     * @param offset
     * @param len    必须是62、63、64
     * @return
     */
    public static String encode6234(long n, int offset, int len) {
        ByteBuffer buffer = ByteBuffer.allocate(ENCODE_62_LENGTH_MAX);
        int mod, of;
        for (int i = 0; i < ENCODE_62_LENGTH_MAX; i++) {
            mod = (int) (n % len);
            if (offset > 0) {
                of = mod + (offset << i);
                //Log.getSlf4jLogger().debug("{},{},{}", i, of, of & Integer.MAX_VALUE);
                of = of < 0 ? of & Integer.MAX_VALUE : of; //修正负数
                buffer.put(BYTES64_09_AZ_az_[of % len]);
            } else {
                buffer.put(BYTES64_09_AZ_az_[mod]);
            }

            n = n / len;
            if (n == 0 /*&& i >= ENCODE_62_LENGTH_MIN*/) {
                break;
            }
        }

        return ArrayUtil.toReverseString(buffer);
    }

}
